/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.dmp.factory.deserializer;

import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.xmlbeans.XmlObject;
import org.openmetadata.beans.ContextualStringBean;
import org.openmetadata.beans.ContextualStructuredStringBean;
import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.LanguageKeyedValueBean;
import org.openmetadata.beans.NamableBean;
import org.openmetadata.beans.deserialization.Populator;
import org.openmetadata.beans.dmp.DmpIDUtils;
import org.openmetadata.beans.dmp.FieldBean;
import org.openmetadata.beans.dmp.FieldValueBean;
import org.openmetadata.beans.dmp.HeadingBean;
import org.openmetadata.beans.dmp.StringBeanList;
import org.openmetadata.beans.dmp.TextBean;
import org.openmetadata.beans.dmp.TextBeanList;
import org.openmetadata.beans.dmp.TopicBean;
import org.openmetadata.beans.dmp.TopicList;
import org.openmetadata.beans.dmp.definitions.FieldDefinitionBean;
import org.openmetadata.beans.dmp.definitions.HeadingDefinitionBean;
import org.openmetadata.beans.dmp.definitions.TopicDefinitionBean;
import org.openmetadata.beans.dmp.definitions.TopicDefinitionList;
import org.openmetadata.beans.dmp.definitions.impl.DataManagementPlanDefinitionBeanImpl;
import org.openmetadata.beans.dmp.definitions.impl.FieldDefinitionBeanImpl;
import org.openmetadata.beans.dmp.definitions.impl.HeadingDefinitionBeanImpl;
import org.openmetadata.beans.dmp.definitions.impl.TopicDefinitionBeanImpl;
import org.openmetadata.beans.dmp.definitions.impl.TopicDefinitionListImpl;
import org.openmetadata.beans.dmp.factory.DmpBeanFactory;
import org.openmetadata.beans.dmp.factory.deserializer.DmpExternalContentService;
import org.openmetadata.beans.dmp.factory.util.BeanUtilities;
import org.openmetadata.beans.dmp.field.value.BooleanValueBean;
import org.openmetadata.beans.dmp.field.value.DateValueBean;
import org.openmetadata.beans.dmp.field.value.IntegerValueBean;
import org.openmetadata.beans.dmp.field.value.LongStringValueBean;
import org.openmetadata.beans.dmp.field.value.StringValueBean;
import org.openmetadata.beans.dmp.impl.DataManagementPlanBeanImpl;
import org.openmetadata.beans.dmp.impl.FieldBeanImpl;
import org.openmetadata.beans.dmp.impl.HeadingBeanImpl;
import org.openmetadata.beans.dmp.impl.TopicBeanImpl;
import org.openmetadata.beans.dmp.impl.TopicListImpl;
import org.openmetadata.beans.dmp.service.ExternalContentService;
import org.openmetadata.beans.impl.MaintainableBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.impl.VersionableBeanImpl;
import org.openmetadata.store.cache.BeanCache;
import org.openmetadata.xml.core.ContextualStringType;
import org.openmetadata.xml.core.ContextualTextType;
import org.openmetadata.xml.core.IdentifiedObjectType;
import org.openmetadata.xml.core.MaintainedObjectType;
import org.openmetadata.xml.core.NamedObjectType;
import org.openmetadata.xml.core.VersionedObjectType;
import org.openmetadata.xml.report.BooleanFieldType;
import org.openmetadata.xml.report.DateFieldType;
import org.openmetadata.xml.report.FieldType;
import org.openmetadata.xml.report.IntegerFieldType;
import org.openmetadata.xml.report.ReportType;
import org.openmetadata.xml.report.SimpleStringFieldType;
import org.openmetadata.xml.report.StringFieldType;
import org.openmetadata.xml.report.TextFieldType;
import org.openmetadata.xml.report.TopicType;
import org.openmetadata.xml.report.definition.HeadingType;

public class DmpBeanPopulatorImpl_Old
implements Populator<XmlObject> {
    protected MutableBeanInitializer beanInitializer;
    protected DmpBeanFactory factory;
    protected BeanCache beanCache;
    public static final String DEFAULT_LANG = "en";
    public static final String TYPE_STRING = "string";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_TEXT = "text";
    public static final String TYPE_INTEGER = "integer";
    public static final String TYPE_LONG_STRING = "long_string";
    public static final String TYPE_DATE = "date";

    public DmpBeanPopulatorImpl_Old(DmpBeanFactory factory, MutableBeanInitializer beanInitializer, BeanCache beanCache) {
        this.factory = factory;
        this.beanInitializer = beanInitializer;
        this.beanCache = beanCache;
    }

    public void populate(IdentifiableBean bean, XmlObject source) {
        if (bean instanceof DataManagementPlanDefinitionBeanImpl && source instanceof org.openmetadata.xml.report.definition.ReportType) {
            this.populateDataManagementPlanDefinitionBean((DataManagementPlanDefinitionBeanImpl)bean, (org.openmetadata.xml.report.definition.ReportType)source);
        } else if (bean instanceof DataManagementPlanBeanImpl && source instanceof ReportType) {
            this.populateDataManagementPlanBean((DataManagementPlanBeanImpl)bean, (ReportType)source);
        }
    }

    private void populateDataManagementPlanBean(DataManagementPlanBeanImpl bean, ReportType source) {
        this.populateMaintainableBean((MaintainableBeanImpl)bean, (MaintainedObjectType)source);
        this.populateTopicList(null, bean.getTopics(), source.getTopicList());
    }

    void populateDataManagementPlanDefinitionBean(DataManagementPlanDefinitionBeanImpl dmpBean, org.openmetadata.xml.report.definition.ReportType reportType) {
        this.populateMaintainableBean((MaintainableBeanImpl)dmpBean, (MaintainedObjectType)reportType);
        this.populateTopicDefinitionList(null, dmpBean.getTopics(), reportType.getTopicList());
    }

    void populateHeadingDefinitionBean(HeadingDefinitionBeanImpl hdBean, HeadingType hdType) {
        this.populateTopicDefinitionBean((TopicDefinitionBeanImpl)hdBean, (org.openmetadata.xml.report.definition.TopicType)hdType);
        this.populateTopicDefinitionList((TopicDefinitionBean)hdBean, hdBean.getTopicDefinitionList(), hdType.getTopicList());
    }

    private void populateHeadingBean(HeadingBeanImpl hdBean, org.openmetadata.xml.report.HeadingType hdType) {
        this.populateTopicBean((TopicBeanImpl)hdBean, (TopicType)hdType);
        this.populateTopicList((TopicBean)hdBean, hdBean.getTopicList(), hdType.getTopicList());
    }

    private void populateTopicList(TopicBean parent, TopicList topicList, List<TopicType> list) {
        for (TopicType topicType : list) {
            FieldBeanImpl strField;
            String containerId;
            String id;
            TopicListImpl topicListImpl = (TopicListImpl)topicList;
            if (topicType instanceof org.openmetadata.xml.report.HeadingType) {
                org.openmetadata.xml.report.HeadingType hdType = (org.openmetadata.xml.report.HeadingType)topicType;
                id = topicType.getId();
                containerId = DmpIDUtils.getContainerID((String)id);
                HeadingBeanImpl hdBean = new HeadingBeanImpl(false, id, containerId, this.factory, this.beanInitializer, hdType.getTopicDefinition(), parent);
                topicListImpl.initAdd((HeadingBean)hdBean);
                this.populateHeadingBean(hdBean, hdType);
                this.beanCache.add((Object)hdBean);
                continue;
            }
            if (!(topicType instanceof FieldType)) continue;
            FieldType fieldType = (FieldType)topicType;
            id = fieldType.getId();
            containerId = DmpIDUtils.getContainerID((String)id);
            String definitionID = fieldType.getTopicDefinition();
            if (fieldType instanceof SimpleStringFieldType) {
                strField = new FieldBeanImpl(false, id, containerId, this.factory, this.beanInitializer, definitionID, parent);
                topicListImpl.initAdd((FieldBean)strField);
                this.populateFieldBean(strField, fieldType);
                this.beanCache.add((Object)strField);
                continue;
            }
            if (fieldType instanceof StringFieldType) {
                strField = new FieldBeanImpl(false, id, containerId, this.factory, this.beanInitializer, definitionID, parent);
                topicListImpl.initAdd((FieldBean)strField);
                this.populateFieldBean(strField, fieldType);
                this.beanCache.add((Object)strField);
                continue;
            }
            if (fieldType instanceof DateFieldType) {
                strField = new FieldBeanImpl(false, id, containerId, this.factory, this.beanInitializer, definitionID, parent);
                topicListImpl.initAdd((FieldBean)strField);
                this.populateFieldBean(strField, fieldType);
                this.beanCache.add((Object)strField);
                continue;
            }
            if (fieldType instanceof BooleanFieldType) {
                strField = new FieldBeanImpl(false, id, containerId, this.factory, this.beanInitializer, definitionID, parent);
                topicListImpl.initAdd((FieldBean)strField);
                this.populateFieldBean(strField, fieldType);
                this.beanCache.add((Object)strField);
                continue;
            }
            if (fieldType instanceof IntegerFieldType) {
                strField = new FieldBeanImpl(false, id, containerId, this.factory, this.beanInitializer, definitionID, parent);
                topicListImpl.initAdd((FieldBean)strField);
                this.populateFieldBean(strField, fieldType);
                this.beanCache.add((Object)strField);
                continue;
            }
            if (!(fieldType instanceof TextFieldType)) continue;
            FieldBeanImpl textField = new FieldBeanImpl(false, id, containerId, this.factory, this.beanInitializer, definitionID, parent);
            topicListImpl.initAdd((FieldBean)textField);
            this.populateFieldBean(textField, fieldType);
            this.beanCache.add((Object)textField);
        }
    }

    void populateTopicDefinitionList(TopicDefinitionBean parent, TopicDefinitionList topicDefList, List<org.openmetadata.xml.report.definition.TopicType> list) {
        TopicDefinitionListImpl topicDefListImpl = (TopicDefinitionListImpl)topicDefList;
        for (org.openmetadata.xml.report.definition.TopicType topicType : list) {
            String id = topicType.getId();
            String containerId = DmpIDUtils.getContainerID((String)id);
            if (topicType instanceof HeadingType) {
                HeadingType hdType = (HeadingType)topicType;
                HeadingDefinitionBeanImpl hdBean = new HeadingDefinitionBeanImpl(false, id, containerId, this.beanInitializer, parent);
                topicDefListImpl.initAdd((HeadingDefinitionBean)hdBean);
                this.populateHeadingDefinitionBean(hdBean, hdType);
                this.beanCache.add((Object)hdBean);
                continue;
            }
            if (!(topicType instanceof org.openmetadata.xml.report.definition.FieldType)) continue;
            org.openmetadata.xml.report.definition.FieldType fieldType = (org.openmetadata.xml.report.definition.FieldType)topicType;
            if (fieldType.isSetRepresentation()) {
                FieldDefinitionBeanImpl strFieldDef;
                String representation = fieldType.getRepresentation();
                if (representation.equals(TYPE_STRING)) {
                    if (fieldType.isSetContentService()) {
                        FieldDefinitionBeanImpl stringListFieldDef = new FieldDefinitionBeanImpl(false, id, containerId, this.beanInitializer, StringBeanList.class, parent);
                        topicDefListImpl.initAdd((FieldDefinitionBean)stringListFieldDef);
                        this.populateFieldDefinitionBean(stringListFieldDef, fieldType);
                        this.beanCache.add((Object)stringListFieldDef);
                        continue;
                    }
                    strFieldDef = new FieldDefinitionBeanImpl(false, id, containerId, this.beanInitializer, StringValueBean.class, parent);
                    topicDefListImpl.initAdd((FieldDefinitionBean)strFieldDef);
                    this.populateFieldDefinitionBean(strFieldDef, fieldType);
                    this.beanCache.add((Object)strFieldDef);
                    continue;
                }
                if (representation.equals(TYPE_LONG_STRING)) {
                    strFieldDef = new FieldDefinitionBeanImpl(false, id, containerId, this.beanInitializer, LongStringValueBean.class, parent);
                    topicDefListImpl.initAdd((FieldDefinitionBean)strFieldDef);
                    this.populateFieldDefinitionBean(strFieldDef, fieldType);
                    this.beanCache.add((Object)strFieldDef);
                    continue;
                }
                if (representation.equals(TYPE_DATE)) {
                    strFieldDef = new FieldDefinitionBeanImpl(false, id, containerId, this.beanInitializer, DateValueBean.class, parent);
                    topicDefListImpl.initAdd((FieldDefinitionBean)strFieldDef);
                    this.populateFieldDefinitionBean(strFieldDef, fieldType);
                    this.beanCache.add((Object)strFieldDef);
                    continue;
                }
                if (representation.equals(TYPE_BOOLEAN)) {
                    strFieldDef = new FieldDefinitionBeanImpl(false, id, containerId, this.beanInitializer, BooleanValueBean.class, parent);
                    topicDefListImpl.initAdd((FieldDefinitionBean)strFieldDef);
                    this.populateFieldDefinitionBean(strFieldDef, fieldType);
                    this.beanCache.add((Object)strFieldDef);
                    continue;
                }
                if (representation.equals(TYPE_INTEGER)) {
                    strFieldDef = new FieldDefinitionBeanImpl(false, id, containerId, this.beanInitializer, IntegerValueBean.class, parent);
                    topicDefListImpl.initAdd((FieldDefinitionBean)strFieldDef);
                    this.populateFieldDefinitionBean(strFieldDef, fieldType);
                    this.beanCache.add((Object)strFieldDef);
                    continue;
                }
                if (!representation.equals(TYPE_TEXT)) continue;
                if (fieldType.isSetContentService()) {
                    FieldDefinitionBeanImpl textListFieldDef = new FieldDefinitionBeanImpl(false, id, containerId, this.beanInitializer, TextBeanList.class, parent);
                    topicDefListImpl.initAdd((FieldDefinitionBean)textListFieldDef);
                    this.populateFieldDefinitionBean(textListFieldDef, fieldType);
                    this.beanCache.add((Object)textListFieldDef);
                    continue;
                }
                FieldDefinitionBeanImpl textFieldDef = new FieldDefinitionBeanImpl(false, id, containerId, this.beanInitializer, TextBean.class, parent);
                topicDefListImpl.initAdd((FieldDefinitionBean)textFieldDef);
                this.populateFieldDefinitionBean(textFieldDef, fieldType);
                this.beanCache.add((Object)textFieldDef);
                continue;
            }
            FieldDefinitionBeanImpl strFieldDef = new FieldDefinitionBeanImpl(false, id, containerId, this.beanInitializer, StringValueBean.class, parent);
            topicDefListImpl.initAdd((FieldDefinitionBean)strFieldDef);
            this.populateFieldDefinitionBean(strFieldDef, fieldType);
            this.beanCache.add((Object)strFieldDef);
        }
    }

    <Representation extends FieldValueBean> void populateFieldDefinitionBean(FieldDefinitionBeanImpl<Representation> fdBean, org.openmetadata.xml.report.definition.FieldType fdType) {
        this.populateTopicDefinitionBean((TopicDefinitionBeanImpl)fdBean, (org.openmetadata.xml.report.definition.TopicType)fdType);
    }

    void populateTopicDefinitionBean(TopicDefinitionBeanImpl tdBean, org.openmetadata.xml.report.definition.TopicType tdType) {
        this.populateNamableBean((NamableBean)tdBean, (NamedObjectType)tdType);
        if (tdType.isSetMinOccurs()) {
            BigInteger minOccurs = tdType.getMinOccurs();
            tdBean.setMinOccurs(minOccurs.intValue());
        }
        if (tdType.isSetMaxOccurs()) {
            System.out.println("deserializer: " + tdType.getId());
            Object obj = tdType.getMaxOccurs();
            if (obj instanceof BigInteger) {
                System.out.println("deseralizer max is int: " + obj);
                BigInteger maxOccurs = (BigInteger)obj;
                tdBean.setMaxOccurs(maxOccurs.intValue());
            } else if (obj.equals("unbounded")) {
                System.out.println("deseralizer max is unbounded: " + obj);
                Integer maxOccurs = Integer.MAX_VALUE;
                tdBean.setMaxOccurs(maxOccurs.intValue());
            }
        }
        if (tdType.isSetRecommended()) {
            tdBean.setRecommended(tdType.getRecommended());
        }
        if (tdType.isSetContentService()) {
            String contentServiceId = tdType.getContentService();
            tdBean.setExternalContentService((ExternalContentService)new DmpExternalContentService(contentServiceId));
        }
    }

    void populateFieldBean(FieldBeanImpl<?> fBean, FieldType fType) {
        if (fType.schemaType().isAssignableFrom(SimpleStringFieldType.type)) {
            StringValueBean bean = (StringValueBean)fBean.getValue();
            SimpleStringFieldType type = (SimpleStringFieldType)fType;
            bean.setValue(BeanUtilities.getMixedContent(type.getSimpleString().copy()));
        } else if (fType.schemaType().isAssignableFrom(StringFieldType.type)) {
            LongStringValueBean bean = (LongStringValueBean)fBean.getValue();
            StringFieldType type = (StringFieldType)fType;
            String stringValue = BeanUtilities.getMixedContent(((ContextualStringType)type.getStringList().get(0)).copy());
            if (type.getStringList().size() > 1) {
                StringBuffer strBuf = new StringBuffer();
                strBuf.append(stringValue);
                int i = 1;
                while (i < type.getStringList().size()) {
                    strBuf.append(BeanUtilities.getMixedContent(((ContextualStringType)type.getStringList().get(i)).copy()));
                    ++i;
                }
                stringValue = strBuf.toString();
            }
            bean.setValue(stringValue);
        } else if (fType.schemaType().isAssignableFrom(DateFieldType.type)) {
            DateValueBean bean = (DateValueBean)fBean.getValue();
            DateFieldType type = (DateFieldType)fType;
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            try {
                bean.setValue(formatter.parse(BeanUtilities.getMixedContent(type.getDate().copy())));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else if (fType.schemaType().isAssignableFrom(BooleanFieldType.type)) {
            BooleanValueBean bean = (BooleanValueBean)fBean.getValue();
            BooleanFieldType type = (BooleanFieldType)fType;
            bean.setValue(new Boolean(BeanUtilities.getMixedContent(type.getBoolean().copy())).booleanValue());
        } else if (fType.schemaType().isAssignableFrom(IntegerFieldType.type)) {
            IntegerValueBean bean = (IntegerValueBean)fBean.getValue();
            IntegerFieldType type = (IntegerFieldType)fType;
            try {
                bean.setValue(new Integer(BeanUtilities.getMixedContent(type.getInteger().copy())).intValue());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        } else if (fType.schemaType().isAssignableFrom(TextFieldType.type)) {
            TextBean bean = (TextBean)fBean.getValue();
            TextFieldType type = (TextFieldType)fType;
            String textValue = BeanUtilities.getMixedContent(((ContextualStringType)type.getTextList().get(0)).copy());
            if (type.getTextList().size() > 1) {
                StringBuffer strBuf = new StringBuffer();
                strBuf.append(textValue);
                int i = 1;
                while (i < type.getTextList().size()) {
                    strBuf.append(BeanUtilities.getMixedContent(((ContextualStringType)type.getTextList().get(i)).copy()));
                    ++i;
                }
                textValue = strBuf.toString();
            }
            bean.setValue(textValue);
        }
    }

    void populateTopicBean(TopicBeanImpl tBean, TopicType tType) {
        this.populateIdentifiableBean((IdentifiableBean)tBean, (IdentifiedObjectType)tType);
    }

    void populateIdentifiableBean(IdentifiableBean idBean, IdentifiedObjectType idObjType) {
    }

    void populateNamableBean(NamableBean namableBean, NamedObjectType namableObjType) {
        this.populateIdentifiableBean((IdentifiableBean)namableBean, (IdentifiedObjectType)namableObjType);
        this.populateContextualStringValueBean((LanguageKeyedValueBean<ContextualStringBean>)namableBean.getName(), namableObjType.getNameList());
        this.populateContextualStructuredStringValueBean((LanguageKeyedValueBean<ContextualStructuredStringBean>)namableBean.getDocumentation(), namableObjType.getDocumentationList());
    }

    void populateVersionableBean(VersionableBeanImpl verBean, VersionedObjectType verObjType) {
        this.populateNamableBean((NamableBean)verBean, (NamedObjectType)verObjType);
        if (verObjType.isSetVersion()) {
            String version = verObjType.getVersion();
            verBean.initSetVersion(version);
        }
        if (verObjType.isSetValidFrom()) {
            verBean.setValidFrom(verObjType.getValidFrom());
        }
        if (verObjType.isSetValidTo()) {
            verBean.setValidTo(verObjType.getValidTo());
        }
    }

    void populateMaintainableBean(MaintainableBeanImpl mtnBean, MaintainedObjectType mtnObjType) {
        this.populateVersionableBean((VersionableBeanImpl)mtnBean, (VersionedObjectType)mtnObjType);
    }

    void populateContextualStringValueBean(LanguageKeyedValueBean<ContextualStringBean> valueBean, List<ContextualStringType> list) {
        for (ContextualStringType cst : list) {
            String lang = cst.isSetLang() ? cst.getLang() : DEFAULT_LANG;
            String value = DmpBeanPopulatorImpl_Old._getMixedContent((XmlObject)cst);
            ((ContextualStringBean)valueBean.getBean(lang)).setValue(value);
        }
    }

    void populateContextualStructuredStringValueBean(LanguageKeyedValueBean<ContextualStructuredStringBean> valueBean, List<ContextualTextType> list) {
        for (ContextualTextType ctt : list) {
            String lang = ctt.isSetLang() ? ctt.getLang() : DEFAULT_LANG;
            String value = DmpBeanPopulatorImpl_Old._getMixedContent((XmlObject)ctt);
            ((ContextualStructuredStringBean)valueBean.getBean(lang)).setXhtml(value);
        }
    }

    public static String _getMixedContent(XmlObject xmlObj) {
        String mixedContent = BeanUtilities.getMixedContent(xmlObj.copy());
        String unescapedXmlText = StringEscapeUtils.unescapeXml((String)mixedContent);
        String unescapedXhtmlText = StringEscapeUtils.unescapeHtml((String)unescapedXmlText);
        return unescapedXhtmlText;
    }
}

