/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.dmp.factory;

import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.dmp.DmpIDUtils;
import org.openmetadata.beans.notification.ChangeEvent;
import org.openmetadata.beans.notification.IdentifiableChangeEvent;
import org.openmetadata.beans.notification.impl.IdentifiableChangeEventImpl;
import org.openmetadata.store.cache.BeanCache;
import org.openmetadata.store.managers.impl.ChangeManagerImpl;

public class DmpChangeManager
extends ChangeManagerImpl {
    private BeanCache beanCache;

    public DmpChangeManager(BeanCache beanCache) {
        this.beanCache = beanCache;
    }

    public void notifyChangeEvent(IdentifiableChangeEvent event) {
        String containerId;
        String beanId = event.getBean().getPrimaryIdentifier();
        if (beanId.equals(containerId = DmpIDUtils.getContainerID((String)beanId))) {
            super.notifyChangeEvent(event);
        } else {
            IdentifiableBean containerBean = (IdentifiableBean)this.beanCache.get(containerId);
            IdentifiableChangeEventImpl containerUpdateEvent = new IdentifiableChangeEventImpl(ChangeEvent.Type.UPDATE, containerBean, new ChangeEvent[0]);
            super.notifyChangeEvent((IdentifiableChangeEvent)containerUpdateEvent);
        }
    }
}

