/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.dataset;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openmetadata.dataset.DataFile;
import org.openmetadata.dataset.DataSource;
import org.openmetadata.dataset.Variable;

public abstract class Transformation {
    Logger logger = Logger.getLogger(this.getClass().getName());
    protected String dataFileName = "";
    protected Map<Variable, List<? extends Object>> inputVariables;
    protected Map<Variable, List<? extends Object>> outputVariables = new LinkedHashMap<Variable, List<? extends Object>>();

    public Transformation(Variable var, DataFile dataFile) {
        DataSource dataSource = dataFile.getDataSource();
        this.dataFileName = dataFile.getFile().getName();
        this.inputVariables = new LinkedHashMap<Variable, List<? extends Object>>();
        try {
            this.inputVariables.put(var, dataSource.getValues(var));
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, var.getName() + " does not have any data associated with it.");
            this.inputVariables.put(var, null);
        }
    }

    public Transformation(List<Variable> variableList, DataFile dataFile) {
        DataSource dataSource = dataFile.getDataSource();
        this.dataFileName = dataFile.getFile().getName();
        this.inputVariables = new LinkedHashMap<Variable, List<? extends Object>>();
        for (Variable var : variableList) {
            try {
                this.inputVariables.put(var, dataSource.getValues(var));
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, var.getName() + " does not have any data associated with it.");
                this.inputVariables.put(var, null);
            }
        }
    }

    public abstract void Transform();

    public Map<Variable, List<? extends Object>> getOutputVariables() {
        return this.outputVariables;
    }
}

