/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.datacube.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openmetadata.datacube.DataCube;
import org.openmetadata.datacube.DimensionKey;
import org.openmetadata.datacube.impl.DataItemImpl;
import org.openmetadata.datacube.impl.DimensionKeySet;

public class DataCubeImpl<T extends DataItemImpl>
implements DataCube<T> {
    private final T[] dataItems;
    private final DimensionKey<?>[] distinctKeys;
    private final Set<String> dimensions;
    private final Set<Class<?>> dimensionClasses;

    public DataCubeImpl(T ... dataItems) {
        this.dataItems = dataItems;
        this.dimensions = new HashSet<String>();
        this.dimensionClasses = new HashSet();
        HashSet<DimensionKey> distinctKeySet = new HashSet<DimensionKey>();
        HashSet<DimensionKeySet> keySets = new HashSet<DimensionKeySet>();
        for (T dataItem : dataItems) {
            DimensionKeySet keySet = ((DataItemImpl)dataItem).getDimensionKeySet();
            for (DimensionKeySet existingKeySet : keySets) {
                if (!existingKeySet.equals(keySet)) continue;
                System.err.println(keySet.getKeys());
                throw new IllegalArgumentException("Cannot create a data item set with containing duplicate keys.");
            }
            keySets.add(keySet);
            for (DimensionKey key : keySet.getKeys()) {
                distinctKeySet.add(key);
                this.dimensions.add(key.getType());
                this.dimensionClasses.add(key.getTypeClass());
            }
        }
        this.distinctKeys = distinctKeySet.toArray(new DimensionKey[0]);
    }

    @Override
    public int size() {
        return this.dataItems.length;
    }

    @Override
    public String[] getDimensions() {
        return this.dimensions.toArray(new String[0]);
    }

    public Class<?>[] getDimensionClasses() {
        return this.dimensionClasses.toArray(new Class[0]);
    }

    public DimensionKey<?>[] getDistinctKeys() {
        return this.distinctKeys;
    }

    @Override
    public T[] getDataItems(DimensionKey<?> ... dimensionKeys) {
        ArrayList<T> returnSet = new ArrayList<T>();
        for (T dataItem : this.dataItems) {
            if (!((DataItemImpl)dataItem).getDimensionKeySet().matches(dimensionKeys)) continue;
            returnSet.add(dataItem);
        }
        return (DataItemImpl[])returnSet.toArray(Arrays.copyOf(this.dataItems, returnSet.size()));
    }
}

