package org.openmetadata.dataset;



/**
 * 
 * A class used to identify records that are desired in a subset.
 * Records will typically be chosen on the value of a certain variable.
 * For example, if a user desired to add all records that had a value of "male" in a variable labeled "sex"
 * the "sex" variable would be added to the targeted variables list.
 * the target value object would be set to "male".
 * Finally there must be a specification that we want all the records containing "male" in the "sex" variable 
 * instead of omitting these cases. That will be done by setting the 
 * @author Andrew DeCarlo
 *
 */

public class RecordSelection extends Selection{

	////////////////////////////////
	//		   VARIABLES
	////////////////////////////////

	//A String containing all the variables to be targeted by the selection
	private String targetVariable;

	//An String used to specify the value that the records should be selected by
	private String targetValue;

	//A case operator variable to identify how we want to handle records that match the given criteria
	private CASE_OPERATOR caseOperator;

	
	////////////////////////////////
	//		   CONSTRUCTOR
	////////////////////////////////
	
	public RecordSelection(String targetVariableName, CASE_OPERATOR caseOperator, Object targetValue){
		this.targetVariable = targetVariableName;
		this.targetValue = targetValue.toString();
		this.caseOperator = caseOperator;
	}	
	
	////////////////////////////////
	//       GETTERS/SETTERS
	////////////////////////////////
	
	public String getTargetVariable() {
		return targetVariable;
	}
	
	public String getTargetValue() {
		return targetValue;
	}
	
	public CASE_OPERATOR getCaseOperation() {
		return caseOperator;
	}

}
