/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.dataset;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openmetadata.dataset.Filter;
import org.openmetadata.dataset.Transformation;
import org.openmetadata.dataset.Variable;

public class TransformDefinition {
    private List<Filter> filters = new ArrayList<Filter>();
    private List<Transformation> transformations = new ArrayList<Transformation>();
    private File transformDataSource = null;
    private ArrayList<Long> recordIndex = new ArrayList();
    private ArrayList<String> createdVariables = new ArrayList();

    public boolean checkForCreatedVariables() {
        for (Transformation transformation : this.transformations) {
            for (Variable var : transformation.getOutputVariables().keySet()) {
                this.createdVariables.add(var.getName());
            }
        }
        return this.createdVariables.size() > 0;
    }

    public Map<Variable, List<? extends Object>> gatherVariablesInformation() throws Exception {
        LinkedHashMap<Variable, List<? extends Object>> variableData = new LinkedHashMap<Variable, List<? extends Object>>();
        for (Transformation transformation : this.transformations) {
            for (Variable var : transformation.getOutputVariables().keySet()) {
                variableData.put(var, transformation.getOutputVariables().get(var));
            }
        }
        return variableData;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public List<Transformation> getTransformations() {
        return this.transformations;
    }

    public ArrayList<String> getCreatedVariables() {
        return this.createdVariables;
    }

    public void addRecordIndex(Long recno) {
        if (this.recordIndex == null) {
            this.recordIndex = new ArrayList();
        }
        this.recordIndex.add(recno);
    }

    public ArrayList<Long> getRecordIndex() {
        return this.recordIndex;
    }
}

