package org.openmetadata.text.impl;

import org.apache.commons.lang3.StringUtils;
import org.openmetadata.text.ContextKey;
import org.openmetadata.text.ContextualText;

public class ContextualTextImpl implements
		ContextualText {

	private final ContextKeySet contextKey;	
	private final boolean isMixed;
	private String value;

	public <V> ContextualTextImpl(ContextKeySet contextKey, String value,
			boolean isMixed) {
		this.contextKey = contextKey;
		this.value = value;
		this.isMixed = isMixed;
	}
	
	ContextKeySet getKeySet() {
		return this.contextKey;
	}

	@Override
	public boolean isMixed() {
		return isMixed;
	}

	@Override
	public ContextKey<?>[] getKeys() {
		return contextKey.getKeys().toArray(new ContextKey<?>[0]);
	}

	@Override
	public String getValue() {
		return StringUtils.defaultString(value);
	}
	
	@Override
	public void setValue(String value) {
		this.value = value;
	}
}
