package org.openmetadata.fileformat;

import java.util.HashMap;

public class AsciiFileFormat implements FileFormat {
	HashMap<String,String> options = new HashMap<String,String>();
	
	public enum ASCII_FORMAT {CSV,CSV_SQL,DELIMITED,FIXED}
	public enum CSV_EXPORT {CODES, CATEGORIES/*, BOTH*/};//TODO add both
	private boolean includeVarNames = false;
	private CSV_EXPORT csvExport;
	private ASCII_FORMAT asciiFormat;
	
	//===============================================================
	// CONSTRUCTORS 
	//===============================================================
	
	public AsciiFileFormat(){
		this.asciiFormat = ASCII_FORMAT.CSV;
	}
	
	public AsciiFileFormat(ASCII_FORMAT asciiFormat) {
		this.asciiFormat = asciiFormat;
		options.put("namesOnFirstRow","true");
		switch(asciiFormat) {
		case CSV:
			options.put("delimiter",",");
			options.put("quoteChar","\"");
			options.put("quoteAll","false");
			options.put("version","csv");
			break;
		case DELIMITED:
			options.put("delimiter","\t");
			options.put("version","delimited");
			break;
		case FIXED:
			options.put("version","fixed");
			break;
		}
	}
	
	//===============================================================
	// INTERFACE 
	//===============================================================
	@Override
	public FORMAT getFormat() {
		return FORMAT.ASCII;
	}
	
	@Override
	public String getFormatName() {
		String formatName = "ASCII Text";
		switch(asciiFormat) {
		case CSV: formatName = "ASCII / Comma Separated Values"; break;
		case DELIMITED: formatName = "ASCII / Delimited"; break;
		case FIXED: formatName = "ASCII / Fixed"; break;
		}
		return formatName;
	}

	@Override
	public HashMap<String, String> getProprietaryAttributes() {
		return this.options;
	}

	@Override
	public String getVersion() {
		return this.options.get("version");
	}

	//===============================================================
	// METHODS 
	//===============================================================
	
	//===============================================================
	// GETTERS / SETTERS
	//===============================================================
	
	public CSV_EXPORT getCsvExport() {
		return csvExport;
	}
	
	public void setCsvExport(CSV_EXPORT csvExport) {
		this.csvExport = csvExport;
	}
	
	public void setIncludeVarNames(boolean includeVarNames) {
		this.includeVarNames = includeVarNames;
	}
	
	public boolean isIncludeVarNames() {
		return includeVarNames;
	}
	
	public ASCII_FORMAT getAsciiFormat() {
		return this.asciiFormat;
	}
	
	public void setAsciiFormat(ASCII_FORMAT format){
		this.asciiFormat = format;
	}
}
