package org.openmetadata.dataset;


/**
 * A class used to identify a variable (or group of variables) that are desired in a subset.
 * There are several ways to specify which variables are desired to added to the subset.
 * For example, if a user desired to add all variables whose label contains "money",
 * the FILTER_TYPE would be ATTR (specifying that we will be looking at the variables attributes which could be ID, NAME, LABEL, or FORMAT)
 * the VAR_ATTR would be LABEL, and the VAR_OPERATOR would be CONTAINS. Variables can also be specified as INDEX (numeric location in the DataFiles list
 * of variables), CATEDGORY, or ROLE (specifying variables that are primary keys, weight variables, or non weighted variables) 
 * @author Andrew DeCarlo
 *
 */
public class VariableSelection extends Selection{
	
	//******************************
	//		   VARIABLES
	//******************************
	private FILTER_TYPE filterType;
	
	private VAR_ATTR varAttr;
	 
	private VAR_OPERATOR varOp;
	
	private ROLE role;
	
	private String value;
	
	private Integer varIndexPosition;
	
	private boolean withCategory = false;

	//******************************
	//		  CONSTRUCTOR
	//******************************
	
	public VariableSelection(){
		
	}
	
	public VariableSelection(VAR_ATTR varAttr, VAR_OPERATOR varOp, String value){
		this.varAttr = varAttr;
		this.varOp = varOp;
		this.value = value;
		this.filterType = FILTER_TYPE.ATTR;
	}
	
	public VariableSelection(Integer varIndexPosition){
		this.varIndexPosition = varIndexPosition;
		this.filterType = FILTER_TYPE.INDEX;
	}
	
	public VariableSelection(ROLE role){
		this.role = role;
		this.filterType = FILTER_TYPE.ROLE;
	}
	
	//******************************
	//		GETTERS/SETTERS
	//******************************

	public FILTER_TYPE getFilterType() {
		return filterType;
	}
	
	public VAR_OPERATOR getOperator() {
		return varOp;
	}
	
	public void setOperator(VAR_OPERATOR varOp) {
		this.varOp = varOp;
	}
	
	public String getValue() {
		return value;
	}
	
	public void setValue(String value) {
		this.value = value;
	}
	
	public VAR_ATTR getVarAttr() {
		return varAttr;
	}
	
	public void setVarAttr(VAR_ATTR varAttr) {
		this.varAttr = varAttr;
	}
	
	public Integer getVarIndexPosition() {
		return varIndexPosition;
	}
	
	public void setVarIndexPosition(Integer varIndexPosition) {
		this.varIndexPosition = varIndexPosition;
	}

	public ROLE getRole() {
		return role;
	}
	
	public void setRole(ROLE role) {
		this.role = role;
	}
	
	public VAR_OPERATOR getVarOp() {
		return varOp;
	}
	
	public void setVarOp(VAR_OPERATOR varOp) {
		this.varOp = varOp;
	}
	
	public boolean getWithCategory(){
		return this.withCategory;
	}
	
	public void setWithCategory(boolean withCategory) {
		this.withCategory = withCategory;
		if(withCategory){
			this.filterType = FILTER_TYPE.CATEGORY;
		}
	}
}
