package org.openmetadata.dataset;

/**
 * A Code in a Codelist
 * @author Pascal Heus (pascal.heus@gmail.com)
 *
 */
public interface Code {

	/**
	 * Codes are used as a way for users to associate a value to a specific data entry.
	 * Codes are a simple entry that will represent a particular label. 
	 * 
	 * Example:
	 * 
	 * Variable: (Sex)
	 * 
	 * Code	|	Label
	 *  1	|	male
	 *  2	|	female
	 *  3	|	no response
	 * 
	 * The code will be returned as a String no matter what data type it is. This is because
	 * the code is not used for any sort of computations, they are simply returned and printed
	 * in scripts or XML documents so there is no need for them to be anything else.
	 * 
	 * @return code as a String
	 */
	public String getCode();
	
	/**
	 * Sets the value of the Code as an Integer. 
	 * @param code
	 */
	public void setCode(Integer code);
	
	/**
	 * Sometimes codes will not be simple Integer values. In fact for some statistical
	 * packages text and decimal numbers can be used as codes. To set Codes that are 
	 * not Integers, developers will have to add methods to set the code as a different
	 * data type. This method returns an object in order to be flexible to those datatypes.
	 * @return value for this code as a Object
	 */
	public Object getCodeValue();
	

	/**
	 * Labels are the value associated with a particular code value. Labels
	 * are the real meaning of a code.
	 * 
	 * Example:
	 * 
	 * Variable: (Sex)
	 * 
	 * Code	|	Label
	 *  1	|	male
	 *  2	|	female
	 *  3	|	no response
	 * 
	 * @return String value of the label associated with the code.
	 */
	public String getLabel();
	
	/**
	 * This is used to flag a particular code as a missing value
	 * @return
	 */
	public Boolean isMissing();
	
	/**
	 * This sets the flag of isMissing
	 * @param missing
	 */
	public void setMissing(Boolean missing);

	/**
	 * This is currently not implemented in any of the data readers.
	 * @return
	 */
	public String getMissingType();

}
