/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.fileformat;

public class FileFormatInfo {
    public Compatibility compatibility = Compatibility.NATIVE;
    public Format format = Format.ASCII;
    public ASCIIFormat asciiFormat = ASCIIFormat.FIXED;
    public char asciiDelimiter = (char)9;
    public boolean namesOnFirstLine = true;

    public FileFormatInfo() {
    }

    public FileFormatInfo(Format format) {
        this.format = format;
    }

    public String toString() {
        String str = this.format.name();
        if (this.format == Format.ASCII) {
            str = String.valueOf(str) + "_" + this.asciiFormat.toString();
            if (this.compatibility != Compatibility.GENERIC) {
                str = String.valueOf(str) + "_" + this.compatibility.toString();
            }
        }
        return str;
    }

    public static enum ASCIIFormat {
        FIXED,
        DELIMITED,
        CSV;

    }

    public static enum Compatibility {
        NATIVE,
        GENERIC;

    }

    public static enum Format {
        ASCII,
        SPSS,
        SAS,
        STATA;

    }
}

