package org.openmetadata.dataset;

public class RangeMissingValue implements MissingValue{

	public enum RANGE_OPERATION {BETWEEN, GREATER_THAN, LESS_THAN, GREATER_EQUAL, LESS_EQUAL};

	private RANGE_OPERATION operation = RANGE_OPERATION.BETWEEN;
	private Double min = Double.MIN_VALUE;
	private Double max = Double.MAX_VALUE;
	private String id ="";
	private String label = "";


	public RangeMissingValue(){

	}

	public RangeMissingValue(String label){
		this.label = label;
	}

	public RANGE_OPERATION getOperation() {
		return operation;
	}

	public void setOperation(RANGE_OPERATION operation) {
		this.operation = operation;
	}

	public Double getMax() {
		return max;
	}

	public void setMax(Double max) {
		this.max = max;
	}

	public Double getMin() {
		return min;
	}

	public void setMin(Double min) {
		this.min = min;
	}

	@Override
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	@Override
	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	@Override
	public boolean isMissing(Object value) {
		boolean isMissing = false;

		Double doubleValue = null;

		try{
			doubleValue = Double.parseDouble(value.toString());
			switch(this.operation){
			case BETWEEN:
				if(doubleValue <= getMax() && doubleValue >= getMin()){
					isMissing=true;
				}
				break;
			case GREATER_THAN:
				if(getMax() != null){
					if(doubleValue > getMax()){
						isMissing=true;
					}
				}
				else if(getMin() != null){
					if(doubleValue > getMin()){
						isMissing=true;
					}
				}
				break;
			case LESS_THAN:
				if(getMax() != null){
					if(doubleValue < getMax()){
						isMissing=true;
					}
				}
				else if(getMin() != null){
					if(doubleValue < getMin()){
						isMissing=true;
					}
				}
				break;
			case GREATER_EQUAL:
				if(getMax() != null){
					if(doubleValue >= getMax()){
						isMissing=true;
					}
				}
				else if(getMin() != null){
					if(doubleValue >= getMin()){
						isMissing=true;
					}
				}
				break;
			case LESS_EQUAL:
				if(getMax() != null){
					if(doubleValue <= getMax()){
						isMissing=true;
					}
				}
				else if(getMin() != null){
					if(doubleValue <= getMin()){
						isMissing=true;
					}
				}
				break;
			default:
			}
		}
		catch(Exception e){
			if(value.toString().equals(".")){
				isMissing = true;
			}
		}

		return isMissing;
	}
}
