package org.openmetadata.key.impl;

import java.util.HashSet;
import java.util.Set;

import org.openmetadata.key.Key;

/**
 * 
 * @author Kyaw Soe
 * 
 * @param <K>
 */
public class KeySet<K extends Key<?>> {

	private final Set<K> keySet;

	public KeySet(K... keys) {
		keySet = new HashSet<K>();
		HashSet<String> keyTypeSet = new HashSet<String>();
		for (K key : keys) {
			String type = key.getType();
			if (keyTypeSet.contains(type)) {
				throw new IllegalArgumentException(
						"Illegal duplicate key type [" + type + "].");
			}
			keyTypeSet.add(type);
			keySet.add(key);
		}
	}

	public int size() {
		return keySet.size();
	}

	public Set<? extends K> getKeys() {
		return new HashSet<K>(keySet);
	}

	public boolean matches(Key<?>... testKeys) {
		if (keySet.size() >= testKeys.length) {
			KeySet<Key<?>> testKeySet = new KeySet<Key<?>>(testKeys);
			return keySet.containsAll(testKeySet.getKeys());
		} else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return keySet.hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == this) {
			return true;
		} else if (obj instanceof KeySet) {
			return keySet.equals(((KeySet<?>) obj).getKeys());
		} 
		return false;
	}

}
