package org.openmetadata.key;

/**
 * Top-level interface for all keys.
 * 
 * @author Kyaw Soe
 * 
 * @param <V>
 */
public interface Key<V> {
	
	/**
	 * Returns the value (or enumeration) associated with the type of the key.
	 * @return
	 */
	V getValue();

	/**
	 * Returns a unique string identifying the type of the key.
	 * 
	 * @return string that uniquely identifies the type of the key.
	 */
	String getType();

	/**
	 * Describe the type of the key.
	 * 
	 * @return a <code>Class</code> object reflecting the type of the key.
	 */
	Class<?> getTypeClass();
}
