package org.openmetadata.text;

/**
 * The text value of a <code>ContextualText</code> may be simple string or mixed
 * content (XHTML). The text value is uniquely identified by a set of unique keys.
 * 
 * @author Kyaw Soe
 * 
 */
public interface ContextualText {
	
	ContextKey<?>[] getKeys();

	/**
	 * Return the value.
	 * @return
	 */
	String getValue();
	
	void setValue(String value);

	/**
	 * Determines whether the text value is simple string or mixed content
	 * (XHTML).
	 * 
	 * @return <code>true</code> if the text value is mixed content (XHTML).
	 */
	boolean isMixed();

}
