package org.openmetadata.dataset;

import java.util.LinkedHashMap;

public interface CodeList {
	
	/**
	 * CodeLists are held in Maps in the datareaders. The key used to identify
	 * them are the codelist ID. This is held in the variables that the codelist
	 * applies to. When it is necessary to retrieve a variables code list, the developer
	 * could use the codelist ID to retrieve it from the codelist Map in the DataFile
	 * 
	 * @return the code list identifier, unique within its context
	 */
	public String getId();

	/**
	 * A LinkedHashMap is used to store the codes (which contain the codes and labels) 
	 * for a codelist. This is currently a bit redundant as developers may call
	 * dataFile.getCodelist(id).getCodelist() and than iterate through all the values
	 * of the LinkedHashMap to access the codes. In the future this could be revised
	 * to be a List of codes.
	 * 
	 * @return ordered list of codes and labels
	 */
	public LinkedHashMap<String, Code> getCodeList();
	
	/**
	 * Returns a particular Label held in the CodeList. Currently not implemented in 
	 * the data readers.
	 * 
	 * @return label for this code
	 */
	public Code getCode(String value);
	
}
