package org.openmetadata.progress.impl;

import org.openmetadata.progress.ProgressIndicator;

public class ConsoleProgressIndicator implements ProgressIndicator{

	private Long maxCount;
	
	@Override
	public void setMax(Long maxCount) {
		this.maxCount = maxCount;
	}

	@Override
	public void update(Long current) {
		if(maxCount != null){
			System.out.println(current+"/"+maxCount);
		}else{
			throw new RuntimeException("The max count must be set before updating.");
		}
	}

	
}
