package org.openmetadata.text;

public enum DocumentationTypeContextKey implements
		ContextKey<DocumentationTypeContextKey> {

	ABSTRACT, ANNOTATION, DESCRIPTION, DEVELOPMENT_NOTE, GUIDANCE, USER_INSTRUCTION;

	private DocumentationTypeContextKey() {
	}

	public static DocumentationTypeContextKey valueFor(Object o) {
		String val = o.toString().toUpperCase();
		return DocumentationTypeContextKey.valueOf(val);
	}

	@Override
	public DocumentationTypeContextKey getValue() {
		return this;
	}

	@Override
	public String getTextValue() {
		return toString();
	}

	@Override
	public String getType() {
		return "org.openmetadata.text.key.type";
	}

	@Override
	public Class<DocumentationTypeContextKey> getTypeClass() {
		return DocumentationTypeContextKey.class;
	}
}
