package org.openmetadata.datacube;



/**
 * A <code>DataCube</code> object represents a multidimensional dataset where
 * the data items can have an arbitrary number of dimensions.
 * 
 * @author Kyaw Soe
 * 
 * @param <T>
 */
public interface DataCube<T extends DataItem> {
	
	int size();
	
	/**
	 * Return an array of unique strings reflecting the dimensions associated with the data items.
	 * 
	 * @return an array of unique strings representing the dimensions.
	 */
	String[] getDimensions();
		
	/**
	 * Gets the data items matching the key provided. This may return more than
	 * one data item if the provided key is a subset of the contexts of the
	 * actual data items.
	 * 
	 * @param dimensionKeys
	 *            the dimension keys for which data values are sought
	 * @return the context text items with full or partial keys matching the
	 *         provided key; array will be empty if there are no matches
	 */
	T[] getDataItems(DimensionKey<?>... dimensionKeys);
}
