package org.openmetadata.text;

public class SimpleContextKey<V> implements ContextKey<V> {

	private final String type;
	private final V value;

	public SimpleContextKey(String type, V value) {
		this.type = type;
		this.value = value;
	}

	@Override
	public V getValue() {
		return value;
	}

	@Override
	public String getTextValue() {
		return value.toString();
	}

	@Override
	public String getType() {
		return type;
	}

	@Override
	public int hashCode() {
		return value.hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if (obj != null) {
			if (obj instanceof SimpleContextKey<?>) {
				SimpleContextKey<?> otherKey = (SimpleContextKey<?>) obj;
				if (value.equals(otherKey)) {
					return true;
				} else if (this.getType().equals(otherKey.getType())
						&& this.hashCode() == otherKey.hashCode()) {
					return true;
				}
			}
		}
		return false;

	}
	
	@Override
	public Class<?> getTypeClass() {
		return SimpleContextKey.class;
	}
}
