package org.openmetadata.dataset;



public class DiscreteMissingValue implements MissingValue{

	public enum DISCRETE_OPERATION {EQUALS, NOT_EQUALS};
	private String id;
	private String label = "";
	private DISCRETE_OPERATION discreteOperation = DISCRETE_OPERATION.EQUALS;

	public DiscreteMissingValue(){

	}

	public DiscreteMissingValue(String id){
		this.id = id;
	}

	public DiscreteMissingValue(String value, String label){
		this.id = value;
		this.label = label;
	}

	@Override
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	@Override
	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	@Override
	public boolean isMissing(Object value) {
		boolean isMissing = false;

		try{
			Double doubleValue = Double.parseDouble(value.toString());
			Double doubleMissing = Double.parseDouble(getId());

			if(discreteOperation == DISCRETE_OPERATION.EQUALS){
				if(doubleValue.equals(doubleMissing)){
					isMissing=true;
				}
			}
			else{
				if(!doubleValue.equals(doubleMissing)){
					isMissing=true;
				}
			}

		}
		catch(Exception e){
			if(getId().equalsIgnoreCase(".")){
				isMissing = true;
			}
			else{
				if(discreteOperation == DISCRETE_OPERATION.EQUALS){
					if(value.toString().trim().equalsIgnoreCase(getId().trim())){
						isMissing=true;
					}
				}
				else{
					if(!value.toString().trim().equalsIgnoreCase(getId().trim())){
						isMissing = true;
					}
				}
			}
		}

		return isMissing;
	}

	public DISCRETE_OPERATION getDiscreteOperation() {
		return discreteOperation;
	}

	public void setDiscreteOperation(DISCRETE_OPERATION discreteOperation) {
		this.discreteOperation = discreteOperation;
	}
}
