package org.openmetadata.datacube.impl;

import org.openmetadata.datacube.DataItem;
import org.openmetadata.datacube.DimensionKey;

/**
 * A simple implementation of <code>DataItem</code> with an arbitrary set of
 * unique dimensional keys.
 * 
 * @author Kyaw Soe
 * 
 */
public class DataItemImpl implements DataItem {

	private DimensionKeySet dimensionKeySet;
	private Object value;

	public DataItemImpl(DimensionKeySet dimensionKeySet, Object value) {
		this.dimensionKeySet = dimensionKeySet;
		this.value = value;
	}

	/**
	 * Implementation specific method that returns the set containing the
	 * dimension keys.
	 * 
	 * @return a <code>DimensionKeySet</code> object
	 */
	public DimensionKeySet getDimensionKeySet() {
		return dimensionKeySet;
	}

	@Override
	public DimensionKey<?>[] getDimensionKeys() {
		return dimensionKeySet.getKeys().toArray(new DimensionKey<?>[0]);
	}

	@Override
	public Object getValue() {
		return value;
	}
}
