package org.openmetadata.datacube;

/**
 * A <code>DataItem</code> object holds a value which is uniquely identified by
 * an arbitrary set of unique keys. This class is intended to be sub-classed.
 * 
 * @author Kyaw Soe
 * 
 */
public interface DataItem {

	/**
	 * Returns an array of keys reflecting the dimensions that identify the
	 * value of the data item.
	 * 
	 * @return an array of <code>DimensionKey</code> objects.
	 */
	DimensionKey<?>[] getDimensionKeys();

	/**
	 * Returns the value of a <code>DataItem</code> object. The subclass shall
	 * override the method return type.
	 * 
	 * @return an object representing the value of the data item.
	 */
	Object getValue();
}
