/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.text.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openmetadata.text.ContextKey;
import org.openmetadata.text.ContextualText;
import org.openmetadata.text.ContextualTextSet;
import org.openmetadata.text.impl.ContextKeySet;
import org.openmetadata.text.impl.ContextualTextImpl;

public abstract class AbstractContextualTextSetImpl<T extends ContextualTextImpl>
implements ContextualTextSet {
    private final Set<T> itemSet;
    private final T[] emptyTypeArray;

    public AbstractContextualTextSetImpl(T ... items) {
        this.emptyTypeArray = (ContextualTextImpl[])Arrays.copyOf(items, 0);
        HashSet<ContextKeySet> keySets = new HashSet<ContextKeySet>();
        this.itemSet = new LinkedHashSet<T>();
        T[] TArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            T item = TArray[n2];
            ContextKeySet keySet = ((ContextualTextImpl)item).getKeySet();
            if (keySets.contains(keySet)) {
                throw new IllegalArgumentException("Cannot create a contextual text set with containing duplicate keys.");
            }
            keySets.add(keySet);
            this.itemSet.add(item);
            ++n2;
        }
    }

    protected abstract T createNew(ContextKey<?> ... var1);

    @Override
    public int size() {
        return this.itemSet.size();
    }

    @Override
    public String[] getContextTypes() {
        HashSet<String> contextTypes = new HashSet<String>();
        for (ContextualTextImpl item : this.itemSet) {
            ContextKeySet keySet = item.getKeySet();
            for (ContextKey key : keySet.getKeys()) {
                contextTypes.add(key.getType());
            }
        }
        return contextTypes.toArray(new String[0]);
    }

    public T getDefault() {
        return (T)(this.itemSet.isEmpty() ? null : (ContextualTextImpl)this.itemSet.iterator().next());
    }

    protected T getDefault(ContextKey<?> ... keys) {
        if (keys == null) {
            throw new IllegalArgumentException("Cannot get a contextual text associated with null keys.");
        }
        ContextKeySet testSet = new ContextKeySet(keys);
        for (ContextualTextImpl item : this.itemSet) {
            if (!item.getKeySet().equals(testSet)) continue;
            return (T)item;
        }
        return null;
    }

    public T get(ContextKey<?> ... keys) {
        T existingObj = this.getDefault(keys);
        if (existingObj != null) {
            return existingObj;
        }
        T newObj = this.createNew(keys);
        this.itemSet.add(newObj);
        return newObj;
    }

    public T[] find(ContextKey<?> ... keys) {
        ArrayList<ContextualTextImpl> returnSet = new ArrayList<ContextualTextImpl>();
        for (ContextualTextImpl item : this.itemSet) {
            if (!item.getKeySet().matches(keys)) continue;
            returnSet.add(item);
        }
        return returnSet.toArray((ContextualTextImpl[])Arrays.copyOf(this.emptyTypeArray, returnSet.size()));
    }

    @Override
    public ContextualText[] getAll() {
        return this.itemSet.toArray((ContextualTextImpl[])Arrays.copyOf(this.emptyTypeArray, this.itemSet.size()));
    }

    @Override
    public boolean remove(ContextualText element) {
        return this.itemSet.remove(element);
    }

    @Override
    public boolean removeAll(Collection<? extends ContextualText> coll) {
        return this.itemSet.removeAll(coll);
    }

    @Override
    public boolean removeAll(ContextKey<?> ... keys) {
        ContextualTextImpl[] matchedItems = this.find(keys);
        return this.itemSet.removeAll(Arrays.asList(matchedItems));
    }
}

