/**
 * <p>
 * The purpose of this package is to provide a generic view of a statistical dataset and related objects.
 * The interfaces defined here are used by data exporter and DDI/script generators and isolate these tools from the proprietary nature of the files.
 * </p>
 * <p>
 * The core object and roles are as follows:
 * <ul>
 * <li>Dataset - a collection of data files with optional relationships
 * </li>
 * <li>DataFile - a collection of variables stored in a file. Can have a primary key. Filter can also be specified to express a subset of the data.
 * </li>
 * <li>Variable - file variable with formatting and optional code list.
 * </li>
 * <li>CodeList - a collection of value/label pairs (Code) for variables. Defined and reused at the DataFile level.
 * </li>
 * <li>MissingValues - describes missing values for variables. Defined and reused at the DataFile level. 
 * </li>
 * <li>DataSource - provides access to data underlying a DataFile with option to read data into memory.
 * </li>
 * <li>Filter - defines constraint on data.
 * </li>
 * <li>Relationship - describes relations between data files  
 * </li>
 * </ul>
 * </p>
 * 
 */
package org.openmetadata.dataset;
