package org.openmetadata.cache;

/**
 * A cache of object in which users can place "locks" on the items. A captured
 * item must be retained by the cache until the time it has been released by all
 * requesters. This includes calls to the {@link #remove(Object)} method;
 * 
 * @author Jack Gager
 * 
 * @param <T>
 */
public interface LockingCache<T extends Object> extends Cache<T> {

	/**
	 * Notifies the cache that the object cannot be disposed from the cache.
	 * 
	 * @param object
	 *            the object to be captured
	 * @param requester
	 *            the object capturing the cached object
	 */
	public void capture(T object, Object requester);

	/**
	 * Notifies the cache that the object can be disposed at the cache's
	 * discretion.
	 * 
	 * @param object
	 *            the object to be released
	 * @param requester
	 *            the object releasing the cached object
	 */
	public void release(T object, Object requester);

}
