package org.openmetadata.key.impl;

import org.openmetadata.key.Key;

/**
 * Base implementation for <code>Key</code>.
 * @author Kyaw Soe
 *
 * @param <V>
 */
public class KeyImpl<V> implements Key<V> {
	
	private Class<?> type;
	private V value;

	public KeyImpl(Class<?> type, V value) {
		if(type == null) {
			throw new IllegalArgumentException("Type must not be null.");
		}
		if(value == null) {
			throw new IllegalArgumentException("Value must not be null.");
		}
			
		this.type = type;
		this.value = value;
	}

	@Override
	public final V getValue() {
		return value;
	}

	@Override
	public final String getType() {
		return type.getName();
	}
	
	@Override
	public final Class<?> getTypeClass() {
		return type;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + type.hashCode();
		result = prime * result + value.hashCode();
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if(this == obj) {
			return true;
		}
		if(obj instanceof Key<?>){
			Key<?> otherKey = (Key<?>) obj;
			boolean sameType = this.getType().equals(otherKey.getType());
			boolean sameValue = this.getValue().equals(otherKey.getValue());
			return sameType && sameValue;
		}else{
			return false;
		}
	}	
}
