package org.openmetadata.cache;

/**
 * A simple cache of objects which have a know identifier.
 * 
 * @author Jack Gager
 */
public interface Cache<T extends Object> {

	/**
	 * Checks whether an object exists in the cache. If this returns true, a
	 * subsequent call to {@link #get(String)} must not return null.
	 * 
	 * @param id
	 *            the id of the object to lookup in the cache
	 * @return true if an object with the supplied identifier exists in the
	 *         cache, otherwise false
	 */
	public boolean contains(String id);

	/**
	 * Retrieves an object from the cache.
	 * 
	 * @param id
	 *            the id of the object to be retrieved
	 * @return the cached object or null if it is not found
	 */
	public T get(String id);

	/**
	 * Adds an object to the cache. If the object already exists in the cache,
	 * it will be updated with the new object.
	 * 
	 * @param object
	 *            the object to be added to the cache
	 */
	public void add(T object);

	/**
	 * Removes an object from the cache.
	 * 
	 * @param object
	 *            the object to be removed from the cache
	 */
	public void remove(T object);

}
