/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.dataset;

import org.openmetadata.dataset.MissingValue;

public class RangeMissingValue
implements MissingValue {
    private RANGE_OPERATION operation = RANGE_OPERATION.BETWEEN;
    private Double min;
    private Double max;
    private String id = "";
    private String label = "";

    public RangeMissingValue() {
    }

    public RangeMissingValue(String label) {
        this.label = label;
    }

    public RANGE_OPERATION getOperation() {
        return this.operation;
    }

    public void setOperation(RANGE_OPERATION operation) {
        this.operation = operation;
    }

    public Double getMax() {
        return this.max;
    }

    public void setMax(Double max) {
        this.max = max;
    }

    public Double getMin() {
        return this.min;
    }

    public void setMin(Double min) {
        this.min = min;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public boolean isMissing(Object value) {
        boolean isMissing;
        block26: {
            isMissing = false;
            Double doubleValue = null;
            try {
                doubleValue = Double.parseDouble(value.toString());
                switch (this.operation) {
                    case BETWEEN: {
                        if (doubleValue <= this.getMax() && doubleValue >= this.getMin()) {
                            isMissing = true;
                        }
                        break;
                    }
                    case GREATER_THAN: {
                        if (this.getMax() != null) {
                            if (doubleValue > this.getMax()) {
                                isMissing = true;
                            }
                        } else if (this.getMin() != null && doubleValue > this.getMin()) {
                            isMissing = true;
                        }
                        break;
                    }
                    case LESS_THAN: {
                        if (this.getMax() != null) {
                            if (doubleValue < this.getMax()) {
                                isMissing = true;
                            }
                        } else if (this.getMin() != null && doubleValue < this.getMin()) {
                            isMissing = true;
                        }
                        break;
                    }
                    case GREATER_EQUAL: {
                        if (this.getMax() != null) {
                            if (doubleValue >= this.getMax()) {
                                isMissing = true;
                            }
                        } else if (this.getMin() != null && doubleValue >= this.getMin()) {
                            isMissing = true;
                        }
                        break;
                    }
                    case LESS_EQUAL: {
                        if (this.getMax() != null) {
                            if (doubleValue <= this.getMax()) {
                                isMissing = true;
                            }
                            break;
                        }
                        if (this.getMin() == null || !(doubleValue <= this.getMin())) break;
                        isMissing = true;
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (Exception e) {
                if (!value.toString().equals(".")) break block26;
                isMissing = true;
            }
        }
        return isMissing;
    }

    public static enum RANGE_OPERATION {
        BETWEEN,
        GREATER_THAN,
        LESS_THAN,
        GREATER_EQUAL,
        LESS_EQUAL;

    }
}

