package org.openmetadata.dataset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class SummaryStatistics {

	//Id based off the SummaryStatisticsOptions Id
	String id;
	double invalid = 0;
	double max = Double.NEGATIVE_INFINITY;
	double min = Double.POSITIVE_INFINITY;
	double median = 0.0;
	double meanValTotal = 0.0;
	double mean = 0.0;
	double stdDeviation= 0.0;
	double variance = 0.0;
	double totalDev = 0.0;
	double valid = 0.0;
	double weight = 1.0;
	boolean secondRun = false;
	boolean isInt = false;
	boolean checkInt = true;
	
	Object mode;

	//List of values to be used to find the median
	ArrayList<Double> values = new ArrayList<Double>();

	//List of standard deviation values
	ArrayList<Double> devValueList = new ArrayList<Double>();

	//List of Unique values
	ArrayList<Object> uniqueValues = new ArrayList<Object>();
	
	//SummaryStatistsOptions
	SummaryStatisticsOptions options;

	//Frequencies of a data Object
	LinkedHashMap<Object,Double> frequencies = new LinkedHashMap<Object,Double>();
	LinkedHashMap<Object,Double> devValueMap = new LinkedHashMap<Object,Double>();
	LinkedHashMap<Integer, Integer> decimals = new LinkedHashMap<Integer,Integer>();

	public SummaryStatistics(SummaryStatisticsOptions options, Variable var, DataFile dataFile) {
		this.options = options;
		setId(options.getId());
		initializeFrequencies(var, dataFile);
	}

	private void initializeFrequencies(Variable var, DataFile dataFile){
		
		if(var.getCodeListId() != null && !var.getCodeListId().isEmpty()){
			for(Code code : dataFile.getCodeList(var.getCodeListId()).getCodeList().values()){
				Object codeValue = code.getCode();
				try{
					codeValue = Double.parseDouble(codeValue.toString());
				}
				catch(Exception e){
				}
				frequencies.put(codeValue, 0.0);
			}
		}		
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public double getMax() {
		return max;
	}

	public void setMax(double max) {
		this.max = max;
	}

	public double getMin() {
		return min;
	}

	public void setMin(double min) {
		this.min = min;
	}

	public double getMean() {
		return mean;
	}

	public void setMean(double mean) {
		this.mean = mean;
	}

	public double getStdDeviation() {
		return stdDeviation;
	}

	public void setStdDeviation(double stdDeviation) {
		this.stdDeviation = stdDeviation;
	}

	public double getMedian() {
		return median;
	}

	public void setMedian(double median) {
		this.median = median;
	}

	public Object getMode() {
		return mode;
	}

	public void setMode(Object mode) {
		this.mode = mode;
	}

	public double getValid() {
		return valid;
	}

	public void setValid(double valid) {
		this.valid = valid;
	}

	public double getInvalid() {
		return invalid;
	}

	public void setInvalid(double invalid) {
		this.invalid = invalid;
	}

	public LinkedHashMap<Object, Double> getFrequencies() {
		return frequencies;
	}

	public void setFrequencies(LinkedHashMap<Object, Double> frequencies) {
		this.frequencies = frequencies;
	}

	public SummaryStatisticsOptions getOptions() {
		return options;
	}

	@Override
	public String toString(){
		return getMax()+"|"+getMin()+"|"+getMean()+"|"+getMean()+"|"+getMode()+"|"
				+getValid()+"|"+getInvalid()+"|"+getFrequencies()+"|";
	}

	public ArrayList<Double> getValues() {
		return values;
	}

	public void setValues(ArrayList<Double> values) {
		this.values = values;
	}

	public double getVariance() {
		return variance;
	}

	public void setVariance(double variance) {
		this.variance = variance;
	}

	public boolean isSecondRun(){
		return secondRun;
	}

	public void setSecondRun(boolean secondRun) {
		this.secondRun = secondRun;
	}

	public double getMeanValTotal() {
		return meanValTotal;
	}

	public void setMeanValTotal(double meanValTotal) {
		this.meanValTotal = meanValTotal;
	}

	public double getTotalDev() {
		return totalDev;
	}

	public void setTotalDev(double totalDev) {
		this.totalDev = totalDev;
	}

	public ArrayList<Double> getDevValueList() {
		return devValueList;
	}

	public void addToDevValueList(Double value){
		devValueList.add(value);
	}

	public HashMap<Object, Double> getDevValueMap() {
		return devValueMap;
	}

	public double getWeight() {
		return weight;
	}

	public void setWeight(double weight) {
		this.weight = weight;
	}
	
	public boolean isInt() {
		return isInt;
	}
	
	public void setIsInt(boolean isInt){
		this.isInt = isInt;
	}
	
	public boolean checkInt(){
		return checkInt;
	}
	
	public void setCheckInt(boolean checkInt) {
		this.checkInt = checkInt;
	}
	
	public HashMap<Integer, Integer> getDecimalsMap() {
		return decimals;
	}
	
	public ArrayList<Object> getUniqueValues() {
		return uniqueValues;
	}

}