package org.openmetadata.dataset;

import java.util.ArrayList;
import java.util.List;


/**
 * A case filter to apply to a data file
 * 
 * @author Andrew DeCarlo
 *
 */
public class Filter {
//no ands in ands and no ors in or
	public enum LOGIC {AND, OR}; 
	
	private LOGIC logic = LOGIC.AND;
	
	private List<Filter> filters = new ArrayList<Filter>();
	
	private List<Selection> selections = new ArrayList<Selection>();
	
	public List<Filter> getFilters() {
		return filters;
	}
	
	public void addFilter(Filter filter){
		this.filters.add(filter);
	}
	
	public void removeFilter(Filter filter){
		this.filters.remove(filter);
	}
	
	public List<Selection> getSelections() {
		return selections;
	}
	
	public void addSelection(Selection selection){
		this.selections.add(selection);
	}
	
	public void removeSelection(Selection selection){
		this.selections.remove(selection);
	}
	
	public LOGIC getLogic() {
		return logic;
	}
	
	public void setLogic(LOGIC logic) {
		this.logic = logic;
	}
	
}
