package org.openmetadata.dataset;

import java.util.LinkedHashMap;
import java.util.List;

public interface DataSet {
	
	/**
	 * @return Descriptive information for this dataset to be used as comments in generated source code
	 */
	public String getDescription();
	
	/**
	 * @return The ordered map of files composing this dataset
	 */
	public LinkedHashMap<String, DataFile> getFiles();
	
	/**
	 * @return Name of the dataset to be used as comments in generated source code
	 */
	public String getName();
	
	/**
	 * @returnThe The list of relationships between files in this dataset
	 */
	public List<Relationship> getFileRelationships();
	
}
