package org.openmetadata.dataset;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TransformDefinition {

	private List<Filter> filters = new ArrayList<Filter>();

	private List<Transformation> transformations = new ArrayList<Transformation>();

	private File transformDataSource = null;
	
	private ArrayList<Long> recordIndex = new ArrayList<Long>();

	private ArrayList<String> createdVariables = new ArrayList<String>();

	////////////////////////////
	//		 CONSTRUCTOR
	////////////////////////////

	public TransformDefinition(){

	}

	////////////////////////////
	//		   METHODS
	////////////////////////////
	
	public boolean checkForCreatedVariables(){
		for(Transformation transformation : this.transformations){
			for(Variable var : transformation.getOutputVariables().keySet()){
				createdVariables.add(var.getName());
			}
		}
		
		if(createdVariables.size() > 0){
			return true;
		}
		else{
			return false;
		}
	}
	
	/**
	 * Combines all of the created variables in one linked hash map and returns it. 
	 * @return
	 * @throws Exception 
	 */
	public Map<Variable, List<? extends Object>> gatherVariablesInformation() throws Exception{

		Map<Variable, List<? extends Object>> variableData = new LinkedHashMap<Variable, List<? extends Object>>();

		for(Transformation transformation : this.transformations){
			for(Variable var : transformation.getOutputVariables().keySet()){
				variableData.put(var,transformation.getOutputVariables().get(var));
			}
		}

		return variableData;
	}


	////////////////////////////
	//		GETTERS/SETTERS
	////////////////////////////

	public List<Filter> getFilters() {
		return filters;
	}

	public List<Transformation> getTransformations() {
		return transformations;
	}

	public ArrayList<String> getCreatedVariables() {
		return createdVariables;
	};
	
	public void addRecordIndex(Long recno){
		if(recordIndex == null){
			recordIndex = new ArrayList<Long>();
		}
		
		recordIndex.add(recno);
	}

	public ArrayList<Long> getRecordIndex() {
		return recordIndex;
	}



}
