package org.openmetadata.dataset;

public class RangeMissingValue implements MissingValue{

	public enum RANGE_OPERATION {BETWEEN, GREATER_THAN, LESS_THAN, GREATER_EQUAL, LESS_EQUAL};

	private RANGE_OPERATION operation = RANGE_OPERATION.BETWEEN;
	private Double min;
	private Double max;
	private String id ="";
	private String label = "";


	public RangeMissingValue(){

	}

	public RangeMissingValue(String label){
		this.label = label;
	}

	public RANGE_OPERATION getOperation() {
		return operation;
	}

	public void setOperation(RANGE_OPERATION operation) {
		this.operation = operation;
	}

	/* Deprecated
	public String getValue() {

		Double trueMin = null;
		Double trueMax = null;
		String operator="";

		if(min != null && max != null){

			//If both of these are set and they are the same value, than no matter what, the range is between 
			if(min == max){
				trueMin = min;
				trueMax = max;
				operator = "-";
			}
			else{
				//Ensure min are set properly
				if(min <= max){
					trueMin = min;
				}
				else{
					trueMin = max;
				}

				//Ensure max are set properly
				if(max >= min){
					trueMax = max;
				}
				else{
					trueMax = min;
				}

				switch(operation){
				case BETWEEN:
					operator = "-";
					break;
				case GREATER_THAN:
					operator = ">";
					break;
				case LESS_THAN:
					operator = "<";
					break;
				default:
				}
			}
			value = trueMin+operator+trueMax;
		}
		else if(min != null || max != null){

			if(min != null){
				trueMin = min;
			}if(value instanceof Number)
			else if(max != null){
				trueMin = max;
			}

				switch(operation){
				case BETWEEN:
					operator = "-";
					value = trueMin+operator+Double.POSITIVE_INFINITY;
					break;
				case GREATER_THAN:
					operator = ">";
					value = operator+trueMin;
					break;
				case LESS_THAN:
					operator = "<";
					value = trueMin+operator;
					break;
				default:
				}
		}

		return value;
	}
	 */

	public Double getMax() {
		return max;
	}

	public void setMax(Double max) {
		this.max = max;
	}

	public Double getMin() {
		return min;
	}

	public void setMin(Double min) {
		this.min = min;
	}

	@Override
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	@Override
	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	@Override
	public boolean isMissing(Object value) {
		boolean isMissing = false;

		Double doubleValue = null;

		try{
			doubleValue = Double.parseDouble(value.toString());
			switch(this.operation){
			case BETWEEN:
				if(doubleValue <= getMax() && doubleValue >= getMin()){
					isMissing=true;
				}
				break;
			case GREATER_THAN:
				if(getMax() != null){
					if(doubleValue > getMax()){
						isMissing=true;
					}
				}
				else if(getMin() != null){
					if(doubleValue > getMin()){
						isMissing=true;
					}
				}
				break;
			case LESS_THAN:
				if(getMax() != null){
					if(doubleValue < getMax()){
						isMissing=true;
					}
				}
				else if(getMin() != null){
					if(doubleValue < getMin()){
						isMissing=true;
					}
				}
				break;
			case GREATER_EQUAL:
				if(getMax() != null){
					if(doubleValue >= getMax()){
						isMissing=true;
					}
				}
				else if(getMin() != null){
					if(doubleValue >= getMin()){
						isMissing=true;
					}
				}
				break;
			case LESS_EQUAL:
				if(getMax() != null){
					if(doubleValue <= getMax()){
						isMissing=true;
					}
				}
				else if(getMin() != null){
					if(doubleValue <= getMin()){
						isMissing=true;
					}
				}
				break;
			default:
			}
		}
		catch(Exception e){
			if(value.toString().equals(".")){
				isMissing = true;
			}
		}

		return isMissing;
	}
}
