/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.key.impl;

import org.openmetadata.key.Key;

public class KeyImpl<V>
implements Key<V> {
    private Class<?> type;
    private V value;

    public KeyImpl(Class<?> type, V value) {
        if (type == null) {
            throw new IllegalArgumentException("Type must not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null.");
        }
        this.type = type;
        this.value = value;
    }

    @Override
    public final V getValue() {
        return this.value;
    }

    @Override
    public final String getType() {
        return this.type.getName();
    }

    @Override
    public final Class<?> getTypeClass() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Key) {
            Key otherKey = (Key)obj;
            boolean sameType = this.getType().equals(otherKey.getType());
            boolean sameValue = this.getValue().equals(otherKey.getValue());
            return sameType && sameValue;
        }
        return false;
    }
}

