package org.openmetadata.dataset;

import java.util.LinkedHashMap;
import java.util.Map;


public interface Variable {
	/** Generic data types */
	public enum DATA_TYPE {DATETIME,NUMERIC,TEXT};
	
	/** Integers and IEEE 754-2008 types 
	 * @see http://en.wikipedia.org/wiki/Integer_type
	 * @see http://en.wikipedia.org/wiki/IEEE_754-2008
	 * */
	enum NUMERIC_TYPE {INT8,INT16,INT32,INT64,INT128,BINARY16,BINARY32,BINARY64,BINARY128,DECIMAL32,DECIMAL64,DECIMAL128};
	
	/**
	 * @return The variable name (unique within a file)
	 */
	public String getName();
	
	/**
	 * @return The variable label
	 */
	public String getLabel();
	
	/**
	 * @return Descriptive information for display purposes
	 */
	public String getDescription();
	
	/**
	 * @return The display format
	 */
	public String getFormat();
	
	/**
	 * @return The generic data type
	 */
	public DATA_TYPE getDataType();
	
	/**
	 * @return The generic data type
	 */
	public NUMERIC_TYPE getNumericType();
	
	/**
	 * @return A software or file format specific data type
	 */	
	public String getProprietaryDataType();
	
	/**
	 * @return the code list identifier or null if not applicable
	 */
	public String getCodeListId();
	
	/** Sets CodeListId **/
	public void setCodeListId(String codeListId);
	
	/**
	 * @return the storage width of a variable Ex: width.decimal 
	 */
	public String getTextStorageWidth();
	
	/**
	 * @return the number of characters required to store this variable values in a fixed ASCII text file
	 */
	public int getTextDisplayWidth(); 
	
	/**
	 * @return 
	 */
	public int getProprietaryDisplayWidth();
	
	/**
	 * @return Software specific proprietary attributes of the variable. 
	 */
	public Map<String, String> getProprietaryAttributes();
	
	/**
	 * @return Width needed to be displayed in an Ascii file. 
	 */
	public void setTextDisplayWidth(int width);
	
	/**
	 * @return the summary statistics of the variable;
	 */
	public SummaryStatistics getSummaryStatistics(String id); // get unweighted summary statistics
	
	/**
	 * @return the variables sumStatMap
	 */
	public  LinkedHashMap<String, SummaryStatistics> getSumStatMap();

	/** allows the Text Storage Width to be set for every variable object **/
	public void setTextStorageWidth(String string);
	
	/** allows the start position for fixed ascii to be retrieved from a variable **/
	public Long getStartPosition();
	
	/** allows the end position for fixed ascii retrieved for a variable **/
	public Long getEndPosition();
	
	/** @return the missing values associated with the variable **/
	public Missing getMissing();
	
}
