/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.dataset;

import java.util.ArrayList;
import java.util.UUID;
import org.openmetadata.dataset.Variable;

public class SummaryStatisticsOptions {
    public String id;
    public ArrayList<STATS> stats;
    ArrayList<Variable> weightVariables = new ArrayList();
    ArrayList<Variable> includedVariables = new ArrayList();
    ArrayList<Variable> excludedVariables = new ArrayList();
    int threshold = 0;

    public SummaryStatisticsOptions() {
        this(UUID.randomUUID().toString());
    }

    public SummaryStatisticsOptions(String id) {
        this.stats = new ArrayList();
        this.id = id;
    }

    public void addStat(STATS stat) {
        this.stats.add(stat);
    }

    public void removeStat(STATS stat) {
        this.stats.remove((Object)stat);
    }

    public void addWeight(Variable var) {
        this.weightVariables.add(var);
        this.excludedVariables.add(var);
    }

    public void removeWeight(Variable var) {
        this.weightVariables.remove(var);
    }

    public void excludeVariable(Variable var) {
        this.excludedVariables.add(var);
    }

    public void includeVariable(Variable var) {
        this.includedVariables.add(var);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ArrayList<STATS> getStats() {
        return this.stats;
    }

    public void setStats(STATS stat) {
        this.stats.add(stat);
    }

    public boolean isWeighted() {
        return this.weightVariables != null && this.weightVariables.size() != 0;
    }

    public boolean isMax() {
        return this.stats.contains((Object)STATS.MAX);
    }

    public void setMax(boolean max) {
        this.addStat(STATS.MAX);
    }

    public boolean isMin() {
        return this.stats.contains((Object)STATS.MIN);
    }

    public void setMin(boolean min) {
        this.addStat(STATS.MIN);
    }

    public boolean isMean() {
        return this.stats.contains((Object)STATS.MEAN);
    }

    public void setMean(boolean mean) {
        this.addStat(STATS.MEAN);
    }

    public boolean isGeometricMean() {
        return this.stats.contains((Object)STATS.GEOMETRIC_MEAN);
    }

    public void setGeometricMean(boolean geometricMean) {
        this.addStat(STATS.GEOMETRIC_MEAN);
    }

    public boolean isHarmonicMean() {
        return this.stats.contains((Object)STATS.HARMONIC_MEAN);
    }

    public void setHarmonicMean(boolean harmonicMean) {
        this.addStat(STATS.HARMONIC_MEAN);
    }

    public boolean isMode() {
        return this.stats.contains((Object)STATS.MODE);
    }

    public void setMode(boolean mode) {
        this.addStat(STATS.MODE);
    }

    public boolean isMedian() {
        return this.stats.contains((Object)STATS.MEDIAN);
    }

    public void setMedian(boolean median) {
        this.addStat(STATS.MEDIAN);
    }

    public boolean isStandardDeviation() {
        return this.stats.contains((Object)STATS.STDEV);
    }

    public void setStandardDeviation(boolean standardDeviation) {
        this.addStat(STATS.STDEV);
    }

    public boolean isValidCases() {
        return this.stats.contains((Object)STATS.VALID);
    }

    public void setValidCases(boolean validCases) {
        this.addStat(STATS.VALID);
    }

    public boolean isInvalidCases() {
        return this.stats.contains((Object)STATS.INVALID);
    }

    public void setInvalidCases(boolean invalidCases) {
        this.addStat(STATS.INVALID);
    }

    public boolean isFrequencies() {
        return this.stats.contains((Object)STATS.FREQ);
    }

    public void setFrequencies(boolean frequencies) {
        this.addStat(STATS.FREQ);
    }

    public ArrayList<Variable> getWeightVariables() {
        return this.weightVariables;
    }

    public ArrayList<Variable> getIncludedVariables() {
        return this.includedVariables;
    }

    public void setIncludedVariables(ArrayList<Variable> includedVariables) {
        this.includedVariables = includedVariables;
    }

    public ArrayList<Variable> getExcludedVariables() {
        return this.excludedVariables;
    }

    public void setExcludedVariables(ArrayList<Variable> excludedVariables) {
        this.excludedVariables = excludedVariables;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public static enum STATS {
        FREQ,
        VARIANCE,
        GEOMETRIC_MEAN,
        HARMONIC_MEAN,
        INVALID,
        MAX,
        MEAN,
        MEDIAN,
        MIN,
        MODE,
        STDEV,
        VALID;

    }
}

