package org.openmetadata.text;


public enum NameTypeContextKey implements ContextKey<NameTypeContextKey> {

	OFFICIAL, DISPLAY, LABEL, LONG, SHORT;

	private NameTypeContextKey() {
	}

	public static NameTypeContextKey valueFor(Object o) {
		String val = o.toString().toUpperCase();
		return NameTypeContextKey.valueOf(val);	
	}

	@Override
	public NameTypeContextKey getValue() {
		return this;
	}
	
	@Override
	public String getTextValue() {
		return toString();
	}
	
	@Override
	public String getType() {
		return "org.openmetadata.text.key.type";
	}
	
	@Override
	public Class<NameTypeContextKey> getTypeClass() {
		return NameTypeContextKey.class;
	}
}
