package org.openmetadata.dataset;

import java.util.ArrayList;
import java.util.UUID;

public class SummaryStatisticsOptions {
	public String id;
	public static enum STATS {FREQ,VARIANCE,GEOMETRIC_MEAN,HARMONIC_MEAN,INVALID,MAX,MEAN,MEDIAN,MIN,MODE,STDEV,VALID};
	public ArrayList<STATS> stats;
	
	ArrayList<Variable> weightVariables = new ArrayList<Variable>();
	ArrayList<Variable> includedVariables = new ArrayList<Variable>();
	ArrayList<Variable> excludedVariables = new ArrayList<Variable>();
	
	int threshold = 0; // 
	
	//===============================================================
	// CONSTRUCTOR
	//===============================================================
	public SummaryStatisticsOptions() {
		this(UUID.randomUUID().toString());
	}
	
	public SummaryStatisticsOptions(String id) {
		this.stats = new ArrayList<STATS>();
		this.id = id;
	}
	
	//===============================================================
	// METHODS
	//===============================================================
	public void addStat(STATS stat) {
		this.stats.add(stat);
	}
	
	public void removeStat(STATS stat) {
		this.stats.remove(stat);
	}
	
	public void addWeight(Variable var){
		this.weightVariables.add(var);
		this.excludedVariables.add(var);
	}
	
	public void removeWeight(Variable var){
		this.weightVariables.remove(var);
	}
	
	public void excludeVariable(Variable var){
		this.excludedVariables.add(var);
	}
	
	public void includeVariable(Variable var){
		this.includedVariables.add(var);
	}
	
	//===============================================================
	// GETTERS/SETTERS
	//===============================================================
	public String getId() {
		return id;
	}
	
	public void setId(String id) {
		this.id = id;
	}
	
	public ArrayList<STATS> getStats() {
		return this.stats;
	}
	
	public void setStats(STATS stat){
		this.stats.add(stat);
	}
	
	public boolean isWeighted() {
		return(weightVariables==null || weightVariables.size()==0);
	}

	public boolean isMax() {
		return stats.contains(STATS.MAX);
	}

	public void setMax(boolean max) {
		addStat(STATS.MAX);
	}

	public boolean isMin() {
		return stats.contains(STATS.MIN);
	}

	public void setMin(boolean min) {
		addStat(STATS.MIN);
	}

	public boolean isMean() {
		return stats.contains(STATS.MEAN);
	}

	public void setMean(boolean mean) {
		addStat(STATS.MEAN);
	}

	public boolean isGeometricMean() {
		return stats.contains(STATS.GEOMETRIC_MEAN);
	}

	public void setGeometricMean(boolean geometricMean) {
		addStat(STATS.GEOMETRIC_MEAN);
	}

	public boolean isHarmonicMean() {
		return stats.contains(STATS.HARMONIC_MEAN);
	}

	public void setHarmonicMean(boolean harmonicMean) {
		addStat(STATS.HARMONIC_MEAN);
	}

	public boolean isMode() {
		return stats.contains(STATS.MODE);
	}

	public void setMode(boolean mode) {
		addStat(STATS.MODE);
	}

	public boolean isMedian() {
		return stats.contains(STATS.MEDIAN);
	}

	public void setMedian(boolean median) {
		addStat(STATS.MEDIAN);
	}

	public boolean isStandardDeviation() {
		return stats.contains(STATS.STDEV);
	}

	public void setStandardDeviation(boolean standardDeviation) {
		addStat(STATS.STDEV);
	}

	public boolean isValidCases() {
		return stats.contains(STATS.VALID);
	}

	public void setValidCases(boolean validCases) {
		addStat(STATS.VALID);
	}

	public boolean isInvalidCases() {
		return stats.contains(STATS.INVALID);
	}

	public void setInvalidCases(boolean invalidCases) {
		addStat(STATS.INVALID);
	}

	public boolean isFrequencies() {
		return stats.contains(STATS.FREQ);
	}

	public void setFrequencies(boolean frequencies) {
		addStat(STATS.FREQ);
	}

	public ArrayList<Variable> getWeightVariables() {
		return this.weightVariables;
	}

	public ArrayList<Variable> getIncludedVariables() {
		return this.includedVariables;
	}

	public void setIncludedVariables(ArrayList<Variable> includedVariables) {
		this.includedVariables = includedVariables;
	}

	public ArrayList<Variable> getExcludedVariables() {
		return this.excludedVariables;
	}
	
	public void setExcludedVariables(ArrayList<Variable> excludedVariables) {
		this.excludedVariables = excludedVariables;
	}
	
	public int getThreshold() {
		return threshold;
	}

	public void setThreshold(int threshold) {
		this.threshold = threshold;
	}

	
}
