/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.datacube.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openmetadata.datacube.DataCube;
import org.openmetadata.datacube.DimensionKey;
import org.openmetadata.datacube.impl.DataItemImpl;
import org.openmetadata.datacube.impl.DimensionKeySet;

public class DataCubeImpl<T extends DataItemImpl>
implements DataCube<T> {
    private final T[] dataItems;
    private final DimensionKey<?>[] distinctKeys;
    private final Set<String> dimensions;
    private final Set<Class<?>> dimensionClasses;

    public DataCubeImpl(T ... dataItems) {
        this.dataItems = dataItems;
        this.dimensions = new HashSet<String>();
        this.dimensionClasses = new HashSet();
        HashSet<DimensionKey> distinctKeySet = new HashSet<DimensionKey>();
        HashSet<DimensionKeySet> keySets = new HashSet<DimensionKeySet>();
        T[] TArray = dataItems;
        int n = dataItems.length;
        int n2 = 0;
        while (n2 < n) {
            T dataItem = TArray[n2];
            DimensionKeySet keySet = ((DataItemImpl)dataItem).getDimensionKeySet();
            if (keySets.contains(keySet)) {
                throw new IllegalArgumentException("Cannot create a data item set with containing duplicate keys.");
            }
            keySets.add(keySet);
            for (DimensionKey key : keySet.getKeys()) {
                distinctKeySet.add(key);
                this.dimensions.add(key.getType());
                this.dimensionClasses.add(key.getTypeClass());
            }
            ++n2;
        }
        this.distinctKeys = distinctKeySet.toArray(new DimensionKey[0]);
    }

    @Override
    public int size() {
        return this.dataItems.length;
    }

    @Override
    public String[] getDimensions() {
        return this.dimensions.toArray(new String[0]);
    }

    public Class<?>[] getDimensionClasses() {
        return this.dimensionClasses.toArray(new Class[0]);
    }

    public DimensionKey<?>[] getDistinctKeys() {
        return this.distinctKeys;
    }

    @Override
    public T[] getDataItems(DimensionKey<?> ... dimensionKeys) {
        ArrayList<T> returnSet = new ArrayList<T>();
        T[] TArray = this.dataItems;
        int n = this.dataItems.length;
        int n2 = 0;
        while (n2 < n) {
            T dataItem = TArray[n2];
            if (((DataItemImpl)dataItem).getDimensionKeySet().matches(dimensionKeys)) {
                returnSet.add(dataItem);
            }
            ++n2;
        }
        return returnSet.toArray((DataItemImpl[])Arrays.copyOf(this.dataItems, returnSet.size()));
    }
}

