/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.cache.impl;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openmetadata.cache.Cache;

public abstract class SoftCache<T>
implements Cache<T> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final Map<String, SoftIdentifiableObjectReference> hash = new HashMap<String, SoftIdentifiableObjectReference>();
    private final SoftIdentifiableObjectReferenceQueue queue = new SoftIdentifiableObjectReferenceQueue();
    private ThreadLocal<T> lastChecked = new ThreadLocal();
    private ThreadLocal<String> lastCheckedId = new ThreadLocal();

    @Override
    public boolean contains(String id) {
        this.logger.debug((Object)("Checking for object: " + id));
        if (id.equals(this.lastCheckedId.get())) {
            return true;
        }
        this.expungeStaleEntries();
        if (this.hash.containsKey(id)) {
            SoftIdentifiableObjectReference soft_ref = this.hash.get(id);
            if (soft_ref != null) {
                this.logger.debug((Object)("Found reference for: " + id));
                Object result = soft_ref.get();
                if (result != null) {
                    this.logger.debug((Object)("Capturing referent for: " + id));
                    this.lastChecked.set(result);
                    this.lastCheckedId.set(id);
                    return true;
                }
                this.hash.remove(id);
            } else {
                this.logger.debug((Object)("Removing null map entry for: " + id));
                this.hash.remove(id);
            }
        }
        return false;
    }

    @Override
    public T get(String id) {
        this.logger.debug((Object)("Getting object: " + id));
        if (id.equals(this.lastCheckedId.get())) {
            return this.lastChecked.get();
        }
        SoftIdentifiableObjectReference ref = this.hash.get(id);
        if (ref == null) {
            return null;
        }
        Object obj = ref.get();
        if (obj == null) {
            this.hash.remove(id);
        }
        return obj;
    }

    @Override
    public void add(T object) {
        String id = this.extractId(object);
        if (id.equals(this.lastCheckedId.get())) {
            this.lastChecked.set(object);
        }
        this.logger.debug((Object)("Adding object: " + id));
        if (this.hash.containsKey(id)) {
            this.logger.debug((Object)("Updating existing object: " + id));
        }
        this.hash.put(id, new SoftIdentifiableObjectReference(object, this.queue));
    }

    @Override
    public void remove(T object) {
        String id = this.extractId(object);
        if (id.equals(this.lastCheckedId.get())) {
            this.lastCheckedId.remove();
            this.lastChecked.remove();
        }
        this.logger.debug((Object)("Removing object: " + id));
        this.hash.remove(id);
    }

    protected abstract String extractId(T var1);

    protected final void expungeStaleEntries() {
        SoftIdentifiableObjectReference sv;
        while ((sv = this.queue.poll()) != null) {
            String id = sv.getId();
            this.logger.debug((Object)("Expunging entry for disposed object: " + id));
            this.hash.remove(id);
        }
    }

    protected final class SoftIdentifiableObjectReference
    extends SoftReference<T> {
        private final String id;

        private SoftIdentifiableObjectReference(T object, SoftIdentifiableObjectReferenceQueue queue) {
            super(object, queue);
            this.id = SoftCache.this.extractId(object);
        }

        private String getId() {
            return this.id;
        }
    }

    protected final class SoftIdentifiableObjectReferenceQueue
    extends ReferenceQueue<T> {
        protected SoftIdentifiableObjectReferenceQueue() {
        }

        public SoftIdentifiableObjectReference poll() {
            return (SoftIdentifiableObjectReference)super.poll();
        }
    }
}

