/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.text.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openmetadata.text.ContextKey;
import org.openmetadata.text.ContextualText;
import org.openmetadata.text.ContextualTextSet;
import org.openmetadata.text.impl.ContextKeySet;
import org.openmetadata.text.impl.ContextualTextImpl;

public abstract class AbstractContextualTextSetImpl<T extends ContextualTextImpl>
implements ContextualTextSet {
    private final LinkedHashSet<T> itemSet;
    private final T[] emptyTypeArray;
    private final Set<String> contextTypes;

    public AbstractContextualTextSetImpl(T ... items) {
        this.emptyTypeArray = (ContextualTextImpl[])Arrays.copyOf(items, 0);
        this.contextTypes = new HashSet<String>();
        HashSet<ContextKeySet> keySets = new HashSet<ContextKeySet>();
        this.itemSet = new LinkedHashSet();
        T[] TArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            T item = TArray[n2];
            ContextKeySet keySet = ((ContextualTextImpl)item).getKeySet();
            if (keySets.contains(keySet)) {
                throw new IllegalArgumentException("Cannot create a contextual text set with containing duplicate keys.");
            }
            keySets.add(keySet);
            this.itemSet.add(item);
            for (ContextKey key : keySet.getKeys()) {
                this.contextTypes.add(key.getType());
            }
            ++n2;
        }
    }

    protected abstract T createNew(ContextKey<?> ... var1);

    @Override
    public String[] getContextTypes() {
        return this.contextTypes.toArray(new String[0]);
    }

    public T getDefault() {
        return (T)(this.itemSet.isEmpty() ? null : (ContextualTextImpl)this.itemSet.iterator().next());
    }

    protected T getDefault(ContextKey<?> ... keys) {
        if (keys == null) {
            throw new IllegalArgumentException("Cannot get a contextual text associated with null keys.");
        }
        ContextKeySet testSet = new ContextKeySet(keys);
        for (ContextualTextImpl item : this.itemSet) {
            if (!item.getKeySet().equals(testSet)) continue;
            return (T)item;
        }
        return null;
    }

    public T get(ContextKey<?> ... keys) {
        T existingObj = this.getDefault(keys);
        if (existingObj != null) {
            return existingObj;
        }
        T newObj = this.createNew(keys);
        this.itemSet.add(newObj);
        return newObj;
    }

    public T[] find(ContextKey<?> ... keys) {
        ArrayList<ContextualTextImpl> returnSet = new ArrayList<ContextualTextImpl>();
        for (ContextualTextImpl item : this.itemSet) {
            if (!item.getKeySet().matches(keys)) continue;
            returnSet.add(item);
        }
        return (ContextualTextImpl[])returnSet.toArray(this.emptyTypeArray);
    }

    @Override
    public ContextualText[] getAll() {
        return (ContextualText[])this.itemSet.toArray(this.emptyTypeArray);
    }
}

