/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.key.impl;

import java.util.HashSet;
import java.util.Set;
import org.openmetadata.key.Key;

public class KeySet<K extends Key<?>> {
    private final Set<K> keySet = new HashSet<K>();

    public KeySet(K ... keys) {
        HashSet<String> keyTypeSet = new HashSet<String>();
        K[] KArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            K key = KArray[n2];
            String type = key.getType();
            if (keyTypeSet.contains(type)) {
                throw new IllegalArgumentException("Illegal duplicate key type [" + type + "].");
            }
            keyTypeSet.add(type);
            this.keySet.add(key);
            ++n2;
        }
    }

    public int size() {
        return this.keySet.size();
    }

    public Set<? extends K> getKeys() {
        return new HashSet<K>(this.keySet);
    }

    public boolean matches(Key<?> ... testKeys) {
        if (this.keySet.size() >= testKeys.length) {
            KeySet testKeySet = new KeySet((Key[])testKeys);
            return this.keySet.containsAll(testKeySet.getKeys());
        }
        return false;
    }

    public int hashCode() {
        return this.keySet.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof KeySet) {
            return this.keySet.equals(((KeySet)obj).getKeys());
        }
        if (obj instanceof Set) {
            return this.keySet.equals(obj);
        }
        return false;
    }
}

