/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.text;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openmetadata.text.ContextKey;
import org.openmetadata.text.ContextKeySet;
import org.openmetadata.text.ContextualText;

public class ContextualTextSet {
    private final LinkedHashSet<ContextualText> textSet;
    private final Set<String> contextTypes = new HashSet<String>();
    private final Set<Class<? extends ContextKey<?>>> contextTypeClasses = new HashSet();

    public ContextualTextSet(ContextualText ... texts) {
        HashSet<ContextKeySet> keySets = new HashSet<ContextKeySet>();
        this.textSet = new LinkedHashSet();
        ContextualText[] contextualTextArray = texts;
        int n = texts.length;
        int n2 = 0;
        while (n2 < n) {
            ContextualText text = contextualTextArray[n2];
            ContextKeySet keySet = text.getKey();
            if (keySets.contains(keySet)) {
                throw new IllegalArgumentException("Cannot create a contextual text set with containing duplicate keys.");
            }
            keySets.add(keySet);
            this.textSet.add(text);
            for (ContextKey key : keySet.getKeys()) {
                this.contextTypes.add(key.getType());
                this.contextTypeClasses.add(key.getTypeClass());
            }
            ++n2;
        }
    }

    public String[] getContextTypes() {
        return this.contextTypes.toArray(new String[0]);
    }

    public Class<? extends ContextKey<?>>[] getContextTypeClasses() {
        return (Class[])this.contextTypeClasses.toArray();
    }

    public ContextualText getDefault() {
        return this.textSet.isEmpty() ? null : (ContextualText)this.textSet.iterator().next();
    }

    public ContextualText getDefault(ContextKey<?> ... keys) {
        ContextKeySet testSet = new ContextKeySet(keys);
        for (ContextualText text : this.textSet) {
            if (!text.getKey().equals(testSet)) continue;
            return text;
        }
        for (ContextualText text : this.textSet) {
            if (!text.getKey().matches(keys)) continue;
            return text;
        }
        return null;
    }

    public ContextualText[] get(ContextKey<?> ... keys) {
        ArrayList<ContextualText> returnSet = new ArrayList<ContextualText>();
        for (ContextualText text : this.textSet) {
            if (!text.getKey().matches(keys)) continue;
            returnSet.add(text);
        }
        return returnSet.toArray(new ContextualText[0]);
    }
}

