/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.datacube;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openmetadata.datacube.DataItem;
import org.openmetadata.datacube.DimensionKey;
import org.openmetadata.datacube.DimensionKeySet;

public class DataCube<T extends DataItem> {
    private final T[] dataItems;
    private final DimensionKey<?>[] distinctKeys;
    private final Set<Class<? extends DimensionKey<?>>> dimensions;

    public DataCube(T ... dataItems) {
        this.dataItems = dataItems;
        this.dimensions = new HashSet();
        HashSet<DimensionKey> distinctKeySet = new HashSet<DimensionKey>();
        HashSet<DimensionKeySet> keySets = new HashSet<DimensionKeySet>();
        T[] TArray = dataItems;
        int n = dataItems.length;
        int n2 = 0;
        while (n2 < n) {
            T dataItem = TArray[n2];
            DimensionKeySet keySet = ((DataItem)dataItem).getDimensionKeySet();
            if (keySets.contains(keySet)) {
                throw new IllegalArgumentException("Cannot create a data item set with containing duplicate keys.");
            }
            keySets.add(keySet);
            for (DimensionKey key : keySet.getKeys()) {
                distinctKeySet.add(key);
                this.dimensions.add(key.getTypeClass());
            }
            ++n2;
        }
        this.distinctKeys = distinctKeySet.toArray(new DimensionKey[0]);
    }

    public Class<? extends DimensionKey<?>>[] getDimensions() {
        return this.dimensions.toArray(new Class[0]);
    }

    public DimensionKey<?>[] getDistinctKeys() {
        return this.distinctKeys;
    }

    public T[] getDataItems(DimensionKey<?>[] dimensionKeys) {
        ArrayList<T> returnSet = new ArrayList<T>();
        T[] TArray = this.dataItems;
        int n = this.dataItems.length;
        int n2 = 0;
        while (n2 < n) {
            T dataItem = TArray[n2];
            if (((DataItem)dataItem).getDimensionKeySet().matches(dimensionKeys)) {
                returnSet.add(dataItem);
            }
            ++n2;
        }
        return returnSet.toArray((DataItem[])Arrays.copyOf(this.dataItems, returnSet.size()));
    }
}

