/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.key;

import java.util.HashSet;
import java.util.Set;
import org.openmetadata.key.Key;

public class KeySet<K extends Key<?>> {
    private final Set<K> keySet = new HashSet<K>();

    public KeySet(K ... keys) {
        HashSet<String> keyTypeSet = new HashSet<String>();
        K[] KArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            K key = KArray[n2];
            String type = key.getType();
            if (keyTypeSet.contains(type)) {
                throw new IllegalArgumentException("Illegal duplicate key type [" + type + "].");
            }
            keyTypeSet.add(type);
            this.keySet.add(key);
            ++n2;
        }
    }

    public Set<? extends K> getKeys() {
        return new HashSet<K>(this.keySet);
    }

    public boolean matches(K ... testKeys) {
        KeySet testKeySet = new KeySet(testKeys);
        if (testKeys.length > this.keySet.size()) {
            return testKeySet.getKeys().containsAll(this.keySet);
        }
        return this.keySet.containsAll(testKeySet.getKeys());
    }

    public int hashCode() {
        return this.keySet.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof KeySet) {
            return this.keySet.equals(((KeySet)obj).getKeys());
        }
        if (obj instanceof Set) {
            return this.keySet.equals(obj);
        }
        return false;
    }
}

