/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.dataset;

import org.openmetadata.dataset.MissingValue;

public class RangeMissingValue
implements MissingValue {
    private RANGE_OPERATION operation = RANGE_OPERATION.BETWEEN;
    private String value = "";
    private Double min;
    private Double max;
    private String id = "";

    public RANGE_OPERATION getOperation() {
        return this.operation;
    }

    public void setOperation(RANGE_OPERATION operation) {
        this.operation = operation;
    }

    @Override
    public String getValue() {
        Double trueMin = null;
        Double trueMax = null;
        String operator = "";
        if (this.min != null && this.max != null) {
            if (this.min == this.max) {
                trueMin = this.min;
                trueMax = this.max;
                operator = "-";
            } else {
                trueMin = this.min <= this.max ? this.min : this.max;
                trueMax = this.max >= this.min ? this.max : this.min;
                switch (this.operation) {
                    case BETWEEN: {
                        operator = "-";
                        break;
                    }
                    case GREATER_THAN: {
                        operator = ">";
                        break;
                    }
                    case LESS_THAN: {
                        operator = "<";
                    }
                }
            }
            this.value = trueMin + operator + trueMax;
        } else if (this.min != null || this.max != null) {
            if (this.min != null) {
                trueMin = this.min;
            } else if (this.max != null) {
                trueMin = this.max;
            }
            switch (this.operation) {
                case BETWEEN: {
                    operator = "-";
                    this.value = trueMin + operator + Double.POSITIVE_INFINITY;
                    break;
                }
                case GREATER_THAN: {
                    operator = ">";
                    this.value = String.valueOf(operator) + trueMin;
                    break;
                }
                case LESS_THAN: {
                    operator = "<";
                    this.value = trueMin + operator;
                }
            }
        }
        return this.value;
    }

    public Double getMax() {
        return this.max;
    }

    public void setMax(Double max) {
        this.max = max;
    }

    public Double getMin() {
        return this.min;
    }

    public void setMin(Double min) {
        this.min = min;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public static enum RANGE_OPERATION {
        BETWEEN,
        GREATER_THAN,
        LESS_THAN;

    }
}

