/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.text;

import java.util.HashSet;
import java.util.Set;
import org.openmetadata.text.ContextKey;

public class ContextKeySet {
    private final HashSet<ContextKey<?>> contextKeySet = new HashSet();

    public ContextKeySet(ContextKey<?> ... contextKeys) {
        HashSet<String> keyTypeSet = new HashSet<String>();
        ContextKey<?>[] contextKeyArray = contextKeys;
        int n = contextKeys.length;
        int n2 = 0;
        while (n2 < n) {
            ContextKey<?> contextKey = contextKeyArray[n2];
            String type = contextKey.getType();
            if (keyTypeSet.contains(type)) {
                throw new IllegalArgumentException("Illegal duplicate key type [" + type + "].");
            }
            keyTypeSet.add(type);
            this.contextKeySet.add(contextKey);
            ++n2;
        }
    }

    public Set<ContextKey<?>> getKeys() {
        return new HashSet(this.contextKeySet);
    }

    public boolean matches(ContextKey<?> ... testKeys) {
        ContextKeySet testKeySet = new ContextKeySet(testKeys);
        if (testKeys.length > this.contextKeySet.size()) {
            return testKeySet.getKeys().containsAll(this.contextKeySet);
        }
        return this.contextKeySet.containsAll(testKeySet.getKeys());
    }

    public int hashCode() {
        return this.contextKeySet.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ContextKeySet) {
            return this.contextKeySet.equals(((ContextKeySet)obj).getKeys());
        }
        if (obj instanceof Set) {
            return this.contextKeySet.equals(obj);
        }
        return false;
    }
}

