/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.fileformat;

import java.util.HashMap;
import org.openmetadata.fileformat.FileFormat;

public class AsciiFileFormat
implements FileFormat {
    HashMap<String, String> options = new HashMap();
    ASCII_FORMAT asciiFormat;

    public AsciiFileFormat() {
        this.asciiFormat = ASCII_FORMAT.FIXED;
    }

    public AsciiFileFormat(ASCII_FORMAT asciiFormat) {
        this.asciiFormat = asciiFormat;
        this.options.put("namesOnFirstRow", "true");
        switch (asciiFormat) {
            case CSV: {
                this.options.put("delimiter", ",");
                this.options.put("quoteChar", "\"");
                this.options.put("quoteAll", "false");
                this.options.put("version", "csv");
                break;
            }
            case DELIMITED: {
                this.options.put("delimiter", "\t");
                this.options.put("version", "delimited");
                break;
            }
            case FIXED: {
                this.options.put("version", "fixed");
            }
        }
    }

    @Override
    public FileFormat.FORMAT getFormat() {
        return FileFormat.FORMAT.ASCII;
    }

    @Override
    public String getFormatName() {
        String formatName = "ASCII Text";
        switch (this.asciiFormat) {
            case CSV: {
                formatName = "ASCII / Comma Separated Values";
                break;
            }
            case DELIMITED: {
                formatName = "ASCII / Delimited";
                break;
            }
            case FIXED: {
                formatName = "ASCII / Fixed";
            }
        }
        return formatName;
    }

    @Override
    public HashMap<String, String> getProprietaryAttributes() {
        return this.options;
    }

    @Override
    public String getVersion() {
        return this.options.get("version");
    }

    public ASCII_FORMAT getAsciiFormat() {
        return this.asciiFormat;
    }

    public void setAsciiFormat(ASCII_FORMAT format) {
        this.asciiFormat = format;
    }

    public static enum ASCII_FORMAT {
        CSV,
        CSV_SQL,
        DELIMITED,
        FIXED;

    }
}

