/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.text;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.openmetadata.text.ContextKey;
import org.openmetadata.text.ContextKeySet;
import org.openmetadata.text.ContextualText;

public class ContextualTextSet {
    private final LinkedHashSet<ContextualText> textSet;

    public ContextualTextSet(ContextualText ... texts) {
        HashSet keySet = new HashSet();
        this.textSet = new LinkedHashSet();
        ContextualText[] contextualTextArray = texts;
        int n = texts.length;
        int n2 = 0;
        while (n2 < n) {
            ContextualText text = contextualTextArray[n2];
            ContextKeySet key = text.getKey();
            if (keySet.contains(key)) {
                throw new IllegalArgumentException("Cannot create a contextual text set with containing duplicate keys.");
            }
            this.textSet.add(text);
            ++n2;
        }
    }

    public ContextualText getDefault() {
        return this.textSet.isEmpty() ? null : (ContextualText)this.textSet.iterator().next();
    }

    public ContextualText getDefault(ContextKey<?> ... keys) {
        ContextKeySet testSet = new ContextKeySet(keys);
        for (ContextualText text : this.textSet) {
            if (!text.getKey().equals(testSet)) continue;
            return text;
        }
        for (ContextualText text : this.textSet) {
            if (!text.getKey().matches(keys)) continue;
            return text;
        }
        return null;
    }

    public ContextualText[] get(ContextKey<?> ... keys) {
        ArrayList<ContextualText> returnSet = new ArrayList<ContextualText>();
        for (ContextualText text : this.textSet) {
            if (!text.getKey().matches(keys)) continue;
            returnSet.add(text);
        }
        return returnSet.toArray(new ContextualText[0]);
    }
}

